/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.listener;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.sorter.DummySortType;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.SetIf;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListenerRegistry {
    private static final ListenerRegistry instance;
    private static Logger log;
    private volatile List<ServerLifecycleListener> serverLifecycleListeners = new ArrayList<ServerLifecycleListener>();

    public static final ListenerRegistry getInstance() {
        return instance;
    }

    private ListenerRegistry() {
    }

    public List<ServerLifecycleListener> getServerLifecycleListeners() {
        return this.serverLifecycleListeners;
    }

    static void buildListeners(List<ListenerEntry> entries) {
        ArrayList<ServerLifecycleListener> newServerLifecycleListeners = new ArrayList<ServerLifecycleListener>();
        for (ListenerEntry entry : entries) {
            try {
                Object listenerInstance = Class.forName(entry.clazzName).newInstance();
                if (!(listenerInstance instanceof ServerLifecycleListener)) continue;
                newServerLifecycleListeners.add((ServerLifecycleListener)listenerInstance);
            }
            catch (InstantiationException e) {
                log.error("buildInterceptors(... " + entry.clazzName + ")", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("buildInterceptors(... " + entry.clazzName + ")", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("buildInterceptors(... " + entry.clazzName + ")", (Throwable)e);
            }
        }
        ListenerRegistry.instance.serverLifecycleListeners = newServerLifecycleListeners;
    }

    static {
        log = LoggerFactory.getLogger(ListenerRegistry.class);
        instance = new ListenerRegistry();
        Config config = new Config();
        try {
            ConfigurationManager.INSTANCE.configure((Object)config);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(ListenerRegistry.class).error("No distributeme config?!", (Throwable)e);
        }
    }

    static class ListenerEntry
    implements IComparable<ListenerEntry> {
        private int number;
        private String clazzName;

        ListenerEntry(int aNumber, String aClazzName) {
            this.number = aNumber;
            this.clazzName = aClazzName;
        }

        public int compareTo(IComparable<? extends ListenerEntry> anotherEntry, int arg1) {
            return BasicComparable.compareInt((int)this.number, (int)((ListenerEntry)anotherEntry).number);
        }

        public String toString() {
            return this.number + " " + this.clazzName;
        }
    }

    @ConfigureMe(name="distributeme")
    public static class Config {
        private List<ListenerEntry> listenerEntries = new ArrayList<ListenerEntry>();

        @AfterConfiguration
        public void reconfigure() {
            ListenerRegistry.buildListeners(StaticQuickSorter.sort(this.listenerEntries, (SortType)new DummySortType()));
        }

        @SetIf(condition=SetIf.SetIfCondition.startsWith, value="listener.")
        public void addInterceptor(String listenerKey, String clazzName) {
            int indexOfDot = listenerKey.indexOf(46);
            int listenerNumber = Integer.parseInt(listenerKey.substring(indexOfDot + 1));
            this.listenerEntries.add(new ListenerEntry(listenerNumber, clazzName));
        }
    }
}

