/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.listener;

import java.util.List;
import org.distributeme.core.listener.ListenerRegistry;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLifecycleListenerShutdownHook
extends Thread {
    private static Logger log = LoggerFactory.getLogger(ServerLifecycleListenerShutdownHook.class);
    private List<ServerLifecycleListener> listeners;

    public ServerLifecycleListenerShutdownHook(List<ServerLifecycleListener> someListeners) {
        this.listeners = someListeners;
    }

    @Override
    public void run() {
        List<ServerLifecycleListener> configuredListeners;
        if (this.listeners != null && this.listeners.size() > 0) {
            for (ServerLifecycleListener listener : this.listeners) {
                try {
                    listener.beforeShutdown();
                }
                catch (Exception e) {
                    log.warn("Exception in listener " + listener.getClass(), (Throwable)e);
                }
            }
        }
        if ((configuredListeners = ListenerRegistry.getInstance().getServerLifecycleListeners()) != null && configuredListeners.size() > 0) {
            for (ServerLifecycleListener listener : configuredListeners) {
                try {
                    listener.beforeShutdown();
                }
                catch (Exception e) {
                    log.warn("Exception in listener " + listener.getClass(), (Throwable)e);
                }
            }
        }
    }
}

