/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.listener;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.charset.Charset;
import java.util.List;
import org.distributeme.core.RMIRegistryUtil;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.distributeme.core.util.LocalServiceDescriptorStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPReregistrationListener
implements ServerLifecycleListener {
    private static Logger log = LoggerFactory.getLogger(UDPReregistrationListener.class);
    public static final String CMD_REGISTER = "register";

    @Override
    public void afterStart() {
        int port = RMIRegistryUtil.getRmiRegistryPort();
        log.debug("Trying to setup incoming UDP Server on port: " + port);
        this.startUdpServer(port);
    }

    @Override
    public void beforeShutdown() {
    }

    private void startUdpServer(int port) {
        try {
            final DatagramSocket serverSocket = new DatagramSocket(port);
            Thread receiver = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        DatagramPacket incomingPacket = new DatagramPacket(new byte[100], 100);
                        try {
                            serverSocket.receive(incomingPacket);
                            String command = new String(incomingPacket.getData(), Charset.defaultCharset());
                            command = command.trim();
                            System.out.println("Incoming command: " + command + ".");
                            if (command == null || !command.equals(UDPReregistrationListener.CMD_REGISTER)) continue;
                            UDPReregistrationListener.this.register();
                            continue;
                        }
                        catch (IOException e) {
                            log.warn("Can't parse incoming packet", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            });
            receiver.start();
        }
        catch (IOException e) {
            log.warn("Can't create server socket", (Throwable)e);
        }
    }

    private void register() {
        List<ServiceDescriptor> descriptors = LocalServiceDescriptorStore.getInstance().getServiceDescriptors();
        System.out.println("Have to register following descriptors: " + descriptors);
        for (ServiceDescriptor descriptor : descriptors) {
            if (RegistryUtil.bind(descriptor)) continue;
            log.error("Couldn't re-bind myself to the central registry at " + RegistryUtil.describeRegistry() + " for " + descriptor);
            System.err.println("Couldn't re-bind myself at the central registry at " + RegistryUtil.describeRegistry() + " for " + descriptor);
        }
    }
}

