/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.qos;

public class QOSEntry {
    private String serviceId;
    private String callId;
    private long timestamp;
    private long blacklistedUntil;

    public QOSEntry(String aServiceId, String aCallId) {
        this.serviceId = aServiceId;
        this.callId = aCallId;
        this.timestamp = System.currentTimeMillis();
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getKey() {
        return QOSEntry.getKey(this.getServiceId(), this.getCallId());
    }

    public static String getKey(String serviceId, String callId) {
        return serviceId + "-" + callId;
    }

    public String toString() {
        return this.getKey() + " age: " + this.getAge() + ", blacklisted? : " + this.blacklistedUntil;
    }

    long getAge() {
        return System.currentTimeMillis() - this.timestamp;
    }

    public void setBlacklistedUntil(long l) {
        this.blacklistedUntil = l;
    }

    public long getBlacklistedUntil() {
        return this.blacklistedUntil;
    }

    public boolean isBlacklistExpired() {
        return System.currentTimeMillis() > this.getBlacklistedUntil();
    }
}

