/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.qos;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.configureme.ConfigurationManager;
import org.distributeme.core.qos.QOSConfiguration;
import org.distributeme.core.qos.QOSEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QOSRegistry {
    private static final Logger log = LoggerFactory.getLogger(QOSRegistry.class);
    private static final QOSRegistry instance = new QOSRegistry();
    private ConcurrentHashMap<String, QOSEntry> entries = new ConcurrentHashMap();
    private ConcurrentHashMap<String, QOSEntry> blacklist = new ConcurrentHashMap();
    private QOSConfiguration configuration = new QOSConfiguration();

    private QOSRegistry() {
        QOSRegistryRunnable r = new QOSRegistryRunnable();
        Thread checker = new Thread(r);
        checker.setDaemon(true);
        checker.setName("QOS-Checker");
        checker.start();
        try {
            ConfigurationManager.INSTANCE.configure((Object)this.configuration);
        }
        catch (IllegalArgumentException e) {
            log.warn("Can't configure QOSRegistry", (Throwable)e);
        }
    }

    public static final QOSRegistry getInstance() {
        return instance;
    }

    public boolean callStarted(String serviceId, String callId) {
        if (this.blacklist.containsKey(serviceId)) {
            return false;
        }
        QOSEntry entry = new QOSEntry(serviceId, callId);
        this.entries.put(entry.getKey(), entry);
        return true;
    }

    public void callFinished(String serviceId, String callId) {
        this.entries.remove(QOSEntry.getKey(serviceId, callId));
    }

    class QOSRegistryRunnable
    implements Runnable {
        QOSRegistryRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                HashMap oldBlackList = new HashMap();
                oldBlackList.putAll(QOSRegistry.this.blacklist);
                Collection allEntries = QOSRegistry.this.entries.values();
                for (QOSEntry entry : allEntries) {
                    if (entry.getAge() <= QOSRegistry.this.configuration.getTimeoutBeforeBlackList()) continue;
                    entry.setBlacklistedUntil(System.currentTimeMillis() + QOSRegistry.this.configuration.getBlacklistDuration());
                    log.info(entry.getServiceId() + " is blacklisted");
                    oldBlackList.remove(entry.getServiceId());
                    QOSRegistry.this.blacklist.put(entry.getServiceId(), entry);
                }
                for (QOSEntry blacklistedEntry : oldBlackList.values()) {
                    if (!blacklistedEntry.isBlacklistExpired()) continue;
                    log.info(blacklistedEntry.getServiceId() + " recovered");
                    QOSRegistry.this.blacklist.remove(blacklistedEntry.getServiceId());
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

