/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.routing;

import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.util.StringUtils;
import org.distributeme.core.routing.Router;
import org.distributeme.core.stats.RoutingStats;
import org.distributeme.core.stats.RoutingStatsCollector;
import org.distributeme.core.stats.RoutingStatsFactory;
import org.distributeme.core.stats.RoutingStatsWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouter
implements Router {
    private static Logger log = LoggerFactory.getLogger(AbstractRouter.class);
    private OnDemandStatsProducer<RoutingStats> producer;
    private String serviceId;

    @Override
    public void customize(String serviceId, String parameter) {
        this.setServiceId(serviceId);
        this.customize(parameter);
    }

    public void customize(String parameter) {
    }

    protected void setServiceId(String serviceId) {
        this.serviceId = serviceId;
        this.producer = new OnDemandStatsProducer(this.serviceId2ProducerId(serviceId), "router", "distributeme", (IOnDemandStatsFactory)RoutingStatsFactory.DEFAULT_INSTANCE);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this.producer);
    }

    protected RoutingStatsCollector getRoutingStats(String serviceId) {
        if (this.producer == null) {
            return new RoutingStatsWrapper(serviceId, null, null);
        }
        RoutingStats caseStats = null;
        try {
            caseStats = (RoutingStats)this.producer.getStats(this.serviceId2Name(serviceId));
        }
        catch (OnDemandStatsProducerException e) {
            log.warn("Can't obtain case stats for " + serviceId, (Throwable)e);
        }
        RoutingStats defaultStats = (RoutingStats)this.producer.getDefaultStats();
        return new RoutingStatsWrapper(serviceId, caseStats, defaultStats);
    }

    private String serviceId2Name(String serviceId) {
        int lastIndexOfUnderscore = serviceId.lastIndexOf(95);
        if (lastIndexOfUnderscore == -1) {
            return serviceId;
        }
        if ((lastIndexOfUnderscore = serviceId.lastIndexOf(95, lastIndexOfUnderscore)) == -1) {
            return serviceId;
        }
        return serviceId.substring(lastIndexOfUnderscore);
    }

    private String serviceId2ProducerId(String serviceId) {
        String[] tokens = StringUtils.tokenize((String)serviceId, (char)'_');
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (tokens[i].length() == 0) continue;
            if (ret.length() > 0) {
                ret.append('_');
            }
            ret.append(tokens[i].charAt(0));
        }
        ret.append('_').append(tokens[tokens.length - 1]).append("-Router");
        return ret.toString();
    }
}

