/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.routing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.routing.AbstractRouterWithFailover;
import org.distributeme.core.routing.ConfigurableRouter;

public abstract class AbstractRouterWithFailOverToNextNode
extends AbstractRouterWithFailover
implements ConfigurableRouter,
FailingStrategy {
    public static final String ATTR_TRIED_INSTANCES = AbstractRouterWithFailOverToNextNode.class.getName() + ".instance";
    private Random random = new Random(System.nanoTime());

    @Override
    public String getServiceIdForCall(ClientSideCallContext clientSideCallContext) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Incoming call " + clientSideCallContext);
        }
        if (this.getServiceAmount() == 0) {
            return clientSideCallContext.getServiceId();
        }
        if (this.failingSupported() && !clientSideCallContext.isFirstCall()) {
            return this.getServiceIdForFailing(clientSideCallContext);
        }
        switch (this.getStrategy()) {
            case MOD_ROUTER: {
                return this.getModBasedServiceId(clientSideCallContext);
            }
            case RR_ROUTER: {
                return this.getRRBasedServiceId(clientSideCallContext);
            }
        }
        throw new AssertionError((Object)(" Routing Strategy " + (Object)((Object)this.getStrategy()) + " not supported in current implementation."));
    }

    private String getServiceIdForFailing(ClientSideCallContext context) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Calculating serviceIdForFailing call. ClientSideCallContext[" + context + "]");
        }
        String originalServiceId = context.getServiceId();
        HashSet<String> instancesThatIAlreadyTried = (HashSet<String>)context.getTransportableCallContext().get(ATTR_TRIED_INSTANCES);
        if (instancesThatIAlreadyTried == null) {
            instancesThatIAlreadyTried = new HashSet<String>();
            context.getTransportableCallContext().put(ATTR_TRIED_INSTANCES, instancesThatIAlreadyTried);
        }
        int lastUnderscore = originalServiceId.lastIndexOf("_");
        String idSubstring = originalServiceId.substring(lastUnderscore + 1);
        try {
            Integer.parseInt(idSubstring);
        }
        catch (NumberFormatException e) {
            return originalServiceId;
        }
        instancesThatIAlreadyTried.add(idSubstring);
        if (instancesThatIAlreadyTried.size() == this.getConfiguration().getNumberOfInstances()) {
            throw new DistributemeRuntimeException("No instance available, we tried all already.");
        }
        String result = null;
        if (instancesThatIAlreadyTried.size() == this.getConfiguration().getNumberOfInstances() - 1) {
            for (int candidate = 0; candidate < this.getConfiguration().getNumberOfInstances(); ++candidate) {
                if (instancesThatIAlreadyTried.contains("" + candidate)) continue;
                result = originalServiceId.substring(0, lastUnderscore + 1) + candidate;
            }
        }
        if (result == null) {
            int candidate;
            int[] candidates = new int[this.getConfiguration().getNumberOfInstances() - instancesThatIAlreadyTried.size()];
            int i = 0;
            for (candidate = 0; candidate < this.getConfiguration().getNumberOfInstances(); ++candidate) {
                if (instancesThatIAlreadyTried.contains("" + candidate)) continue;
                try {
                    candidates[i++] = candidate;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.getLog().error("ERROR 20150306 Got ArrayIndexOutOfBoundsException in calculation of failover node index (increased by one) " + i + ", candidate: " + candidate + ", candidates: " + Arrays.toString(candidates) + "NumberOfInstances: " + this.getConfiguration().getNumberOfInstances() + ", AlreadyTried: " + instancesThatIAlreadyTried + ", Size: " + instancesThatIAlreadyTried.size() + ", ServiceId: " + originalServiceId);
                }
            }
            candidate = candidates[this.random.nextInt(candidates.length)];
            result = originalServiceId.substring(0, lastUnderscore + 1) + candidate;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("serviceIdForFailing result[" + result + "]. ClientSideCallContext[" + context + "]");
        }
        return result;
    }

    @Override
    public void customize(String s) {
        int serviceAmount = 0;
        try {
            serviceAmount = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.getLog().error("Can't set customization parameter " + s + ", send all traffic to default instance");
        }
        if (serviceAmount < 0) {
            throw new AssertionError((Object)("Customization Error! " + s + " Should be positive value, or at least 0"));
        }
        this.getConfiguration().setNumberOfInstances(serviceAmount);
    }
}

