/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.routing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.util.StringUtils;
import org.configureme.ConfigurationManager;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.routing.AbstractRouter;
import org.distributeme.core.routing.ConfigurableRouter;
import org.distributeme.core.routing.GenericRouterConfiguration;
import org.distributeme.core.routing.RouterStrategy;
import org.distributeme.core.stats.RoutingStatsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRouterWithFailover
extends AbstractRouter
implements ConfigurableRouter,
FailingStrategy {
    public static final String UNDER_LINE = "_";
    private final Logger log;
    private GenericRouterConfiguration configuration = new GenericRouterConfiguration();
    private AtomicInteger delegateCallCounter;
    private final Map<String, Integer> modRouteMethodRegistry;

    public AbstractRouterWithFailover() {
        this.log = LoggerFactory.getLogger((String)"DistributeMeRouting");
        this.delegateCallCounter = new AtomicInteger(0);
        if (this.getStrategy() == null) {
            throw new AssertionError((Object)("getStrategy() method should not return NULL. Please check " + this.getClass() + " implementation"));
        }
        this.modRouteMethodRegistry = new HashMap<String, Integer>();
    }

    @Override
    public FailDecision callFailed(ClientSideCallContext clientSideCallContext) {
        RoutingStatsCollector stats = this.getRoutingStats(clientSideCallContext.getServiceId());
        stats.addFailedCall();
        if (!this.failingSupported()) {
            stats.addFailDecision();
            return FailDecision.fail();
        }
        if (clientSideCallContext.getCallCount() < this.getServiceAmount() - 1) {
            stats.addRetryDecision();
            return FailDecision.retry();
        }
        stats.addFailDecision();
        return FailDecision.fail();
    }

    protected String getRRBasedServiceId(ClientSideCallContext context) {
        if (this.configuration.getNumberOfInstances() == 0) {
            return context.getServiceId();
        }
        int fromCounter = this.delegateCallCounter.incrementAndGet();
        if (fromCounter >= this.configuration.getNumberOfInstances()) {
            int oldCounter = fromCounter;
            fromCounter = 0;
            this.delegateCallCounter.compareAndSet(oldCounter, 0);
        }
        return context.getServiceId() + UNDER_LINE + fromCounter;
    }

    protected String getModBasedServiceId(ClientSideCallContext context) {
        if (this.modRouteMethodRegistry.containsKey(context.getMethodName())) {
            List parameters = context.getParameters();
            if (parameters == null) {
                throw new AssertionError((Object)"Method parameters can't be NULL for MOD-Based routing strategy");
            }
            int parameterPosition = this.modRouteMethodRegistry.get(context.getMethodName());
            if (parameters.size() < parameterPosition + 1) {
                throw new AssertionError((Object)("Not properly configured router, parameter count is less than expected - actual: " + parameters.size() + ", expected: " + parameterPosition));
            }
            Object parameter = parameters.get(parameterPosition);
            long parameterValue = this.getModableValue(parameter);
            if (parameterValue < 0L) {
                parameterValue *= -1L;
            }
            String result = context.getServiceId() + UNDER_LINE + parameterValue % (long)this.getServiceAmount();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Returning mod based result : " + result + " for " + context + " where : serversAmount[" + this.getServiceAmount() + "], modableValue[" + parameterValue + "]");
            }
            return result;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Call to method " + context.getMethodName() + " can't be routed using MOD strategy. Building RR strategy based serviceId.");
        }
        return this.getRRBasedServiceId(context);
    }

    protected Logger getLog() {
        return this.log;
    }

    protected GenericRouterConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfigurationName(String serviceId, String configurationName) {
        this.setServiceId(serviceId);
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.configuration, configurationName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Can't configure router and this leaves us in undefined state, probably configuration not found: " + configurationName, e);
        }
    }

    protected int getServiceAmount() {
        return this.getConfiguration().getNumberOfInstances();
    }

    protected abstract boolean failingSupported();

    protected abstract RouterStrategy getStrategy();

    protected abstract long getModableValue(Object var1);

    protected void addModRoutedMethod(String mName, int modableParameterPosition) {
        if (StringUtils.isEmpty((String)mName)) {
            throw new IllegalArgumentException("mName parameter can't be null || empty");
        }
        if (modableParameterPosition < 0) {
            throw new IllegalArgumentException("modableParameterPosition should be greater or equal to 0, no negative values supported");
        }
        this.modRouteMethodRegistry.put(mName, modableParameterPosition);
    }

    protected void addModRoutedMethod(String mName) {
        if (StringUtils.isEmpty((String)mName)) {
            throw new IllegalArgumentException("mName parameter can't be null || empty");
        }
        this.modRouteMethodRegistry.put(mName, 0);
    }
}

