/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.routing;

import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.util.StringUtils;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.routing.AbstractRouterWithFailover;
import org.distributeme.core.routing.ConfigurableRouter;

public abstract class AbstractRouterWithStickyFailOverToNextNode
extends AbstractRouterWithFailover
implements ConfigurableRouter,
FailingStrategy {
    public static final String PARAMETER_KEY_SERVICES = "services";
    public static final String PARAMETER_KEY_TIMEOUT = "timeout";
    public static final String ATTR_TRIED_INSTANCES = AbstractRouterWithStickyFailOverToNextNode.class.getName() + ".instance";
    private Random random = new Random(System.nanoTime());
    private ConcurrentMap<String, Long> serverFailureTimestamps = new ConcurrentHashMap<String, Long>();

    @Override
    public FailDecision callFailed(ClientSideCallContext clientSideCallContext) {
        this.getLog().info(clientSideCallContext.getServiceId() + " marked as failed and will be blacklisted for " + this.getConfiguration().getBlacklistTime() + " ms");
        this.serverFailureTimestamps.put(clientSideCallContext.getServiceId(), System.currentTimeMillis());
        return super.callFailed(clientSideCallContext);
    }

    @Override
    public String getServiceIdForCall(ClientSideCallContext clientSideCallContext) {
        boolean blacklisted;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Incoming call " + clientSideCallContext);
        }
        if (this.getServiceAmount() == 0) {
            this.getRoutingStats(clientSideCallContext.getServiceId()).addRequestRoutedTo();
            return clientSideCallContext.getServiceId();
        }
        if (this.failingSupported() && !clientSideCallContext.isFirstCall()) {
            String serviceId = this.getServiceIdForFailing(clientSideCallContext);
            this.getRoutingStats(serviceId).addRequestRoutedTo();
            return serviceId;
        }
        String selectedServiceId = null;
        switch (this.getStrategy()) {
            case MOD_ROUTER: {
                selectedServiceId = this.getModBasedServiceId(clientSideCallContext);
                break;
            }
            case RR_ROUTER: {
                selectedServiceId = this.getRRBasedServiceId(clientSideCallContext);
                break;
            }
            default: {
                throw new AssertionError((Object)(" Routing Strategy " + (Object)((Object)this.getStrategy()) + " not supported in current implementation."));
            }
        }
        Long lastFailed = (Long)this.serverFailureTimestamps.get(selectedServiceId);
        boolean bl = blacklisted = lastFailed != null && System.currentTimeMillis() - lastFailed < this.getConfiguration().getBlacklistTime();
        if (blacklisted) {
            clientSideCallContext.setServiceId(selectedServiceId);
            this.getRoutingStats(selectedServiceId).addBlacklisted();
            selectedServiceId = this.getServiceIdForFailing(clientSideCallContext);
            this.getRoutingStats(selectedServiceId).addRequestRoutedTo();
            clientSideCallContext.getTransportableCallContext().put("routing.blacklisted", Boolean.TRUE);
            return selectedServiceId;
        }
        this.getRoutingStats(selectedServiceId).addRequestRoutedTo();
        return selectedServiceId;
    }

    private String getServiceIdForFailing(ClientSideCallContext context) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Calculating serviceIdForFailing call. ClientSideCallContext[" + context + "]");
        }
        String originalServiceId = context.getServiceId();
        HashSet<String> instancesThatIAlreadyTried = (HashSet<String>)context.getTransportableCallContext().get(ATTR_TRIED_INSTANCES);
        if (instancesThatIAlreadyTried == null) {
            instancesThatIAlreadyTried = new HashSet<String>();
            context.getTransportableCallContext().put(ATTR_TRIED_INSTANCES, instancesThatIAlreadyTried);
        }
        int lastUnderscore = originalServiceId.lastIndexOf("_");
        String idSubstring = originalServiceId.substring(lastUnderscore + 1);
        instancesThatIAlreadyTried.add(idSubstring);
        if (instancesThatIAlreadyTried.size() == this.getConfiguration().getNumberOfInstances()) {
            throw new DistributemeRuntimeException("No instance available, we tried all already.");
        }
        String result = null;
        if (instancesThatIAlreadyTried.size() == this.getConfiguration().getNumberOfInstances() - 1) {
            for (int candidate = 0; candidate < this.getConfiguration().getNumberOfInstances(); ++candidate) {
                if (instancesThatIAlreadyTried.contains("" + candidate)) continue;
                result = originalServiceId.substring(0, lastUnderscore + 1) + candidate;
            }
        }
        if (result == null) {
            int candidate;
            int[] candidates = new int[this.getConfiguration().getNumberOfInstances() - instancesThatIAlreadyTried.size()];
            int i = 0;
            for (candidate = 0; candidate < this.getConfiguration().getNumberOfInstances(); ++candidate) {
                if (instancesThatIAlreadyTried.contains("" + candidate)) continue;
                candidates[i++] = candidate;
            }
            candidate = candidates[this.random.nextInt(candidates.length)];
            result = originalServiceId.substring(0, lastUnderscore + 1) + candidate;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("serviceIdForFailing result[" + result + "]. ClientSideCallContext[" + context + "]");
        }
        return result;
    }

    @Override
    public void customize(String s) {
        String[] tokens;
        for (String t : tokens = StringUtils.tokenize((String)s, (char)',')) {
            String[] key_value = StringUtils.tokenize((String)t, (char)'=');
            String key = key_value[0];
            String value = key_value[1];
            if ((key = key.toLowerCase()).equals(PARAMETER_KEY_SERVICES)) {
                try {
                    this.getConfiguration().setNumberOfInstances(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    this.getLog().error("Can't set customization parameter " + key + " to " + value + ", send all traffic to default instance");
                }
            }
            if (!key.equals(PARAMETER_KEY_TIMEOUT)) continue;
            try {
                this.getConfiguration().setBlacklistTime(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                this.getLog().error("Can't set customization parameter " + key + " to " + value + ", send all traffic to default instance");
            }
        }
        if (this.getConfiguration().getNumberOfInstances() < 0) {
            throw new AssertionError((Object)("Customization Error! " + s + " Should be positive value, or at least 0"));
        }
    }
}

