/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.routing;

import java.util.concurrent.atomic.AtomicLong;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.routing.AbstractRouter;
import org.distributeme.core.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairRoundRobinRouter
extends AbstractRouter
implements Router {
    private long MAX = 0L;
    private int MOD = 0;
    private AtomicLong callCounter = new AtomicLong(0L);
    private static Logger log = LoggerFactory.getLogger(FairRoundRobinRouter.class);

    @Override
    public void customize(String parameter) {
        try {
            this.MOD = Integer.parseInt(parameter);
            this.MAX = 1000L * (long)this.MOD;
        }
        catch (NumberFormatException e) {
            log.error("Can't set customization parameter " + parameter + ", send all traffic to default instance");
        }
    }

    @Override
    public String getServiceIdForCall(ClientSideCallContext callContext) {
        if (this.MAX == 0L) {
            return callContext.getServiceId();
        }
        long fromCounter = this.callCounter.incrementAndGet();
        if (fromCounter >= this.MAX) {
            long oldCounter = fromCounter;
            fromCounter = 0L;
            this.callCounter.compareAndSet(oldCounter, 0L);
        }
        return callContext.getServiceId() + "_" + fromCounter % (long)this.MOD;
    }
}

