/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.routing;

import java.util.List;
import net.anotheria.util.StringUtils;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.routing.AbstractRouter;
import org.distributeme.core.routing.Router;

public class ParameterBasedModRouter
extends AbstractRouter
implements Router {
    private int mod;
    private int parameterPosition;

    @Override
    public String getServiceIdForCall(ClientSideCallContext callContext) {
        List parameters = callContext.getParameters();
        if (parameters.size() < this.parameterPosition) {
            throw new AssertionError((Object)("Inproperly configured router, parameter count is less than expected - actual: " + parameters.size() + ", expected: " + this.parameterPosition));
        }
        Object parameter = parameters.get(this.parameterPosition);
        long parameterValue = this.getModableValue(parameter);
        return callContext.getServiceId() + "_" + parameterValue % (long)this.mod;
    }

    protected long getModableValue(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 2L : 1L;
        }
        if (o == null) {
            throw new AssertionError((Object)"Null object is not supported");
        }
        throw new AssertionError((Object)("Object " + o + " of type " + o.getClass() + " is not supported"));
    }

    @Override
    public void customize(String parameter) {
        try {
            String[] t = StringUtils.tokenize((String)parameter, (char)',');
            this.mod = Integer.parseInt(t[0]);
            this.parameterPosition = Integer.parseInt(t[1]);
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)("Customization parameter does not consist of two comma-separated numbers " + parameter));
        }
        catch (NullPointerException e) {
            throw new AssertionError((Object)("Customization parameter is obviously null " + parameter));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AssertionError((Object)("Customization parameter does not consist of two comma-separated numbers " + parameter));
        }
    }

    public int getMod() {
        return this.mod;
    }

    public int getParameterPosition() {
        return this.parameterPosition;
    }
}

