/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.routing;

import java.util.concurrent.atomic.AtomicInteger;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.routing.AbstractRouter;
import org.distributeme.core.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinRouter
extends AbstractRouter
implements Router {
    private int MAX = 0;
    private AtomicInteger callCounter = new AtomicInteger(0);
    private static Logger log = LoggerFactory.getLogger(RoundRobinRouter.class);

    @Override
    public void customize(String parameter) {
        try {
            this.MAX = Integer.parseInt(parameter);
        }
        catch (NumberFormatException e) {
            log.error("Can't set customization parameter " + parameter + ", send all traffic to default instance");
        }
    }

    @Override
    public String getServiceIdForCall(ClientSideCallContext callContext) {
        if (this.MAX == 0) {
            return callContext.getServiceId();
        }
        int fromCounter = this.callCounter.incrementAndGet();
        if (fromCounter >= this.MAX) {
            int oldCounter = fromCounter;
            fromCounter = 0;
            this.callCounter.compareAndSet(oldCounter, 0);
        }
        return callContext.getServiceId() + "_" + fromCounter;
    }
}

