/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anotheria.moskito.core.decorators.DecoratorRegistryFactory;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import org.distributeme.core.stats.RoutingStatsCollector;
import org.distributeme.core.stats.RoutingStatsDecorator;

public class RoutingStats
extends AbstractStats
implements RoutingStatsCollector {
    private StatValue requestRoutedTo;
    private StatValue failedCall;
    private StatValue failDecision;
    private StatValue retryDecision;
    private StatValue blackListed;
    private HashMap<String, StatValue> name2value = new HashMap();

    public RoutingStats(String name) {
        super(name);
        this.requestRoutedTo = StatValueFactory.createStatValue((Object)0L, (String)StatDef.RequestRoutedTo.getStatName(), (Interval[])Constants.getDefaultIntervals());
        this.failedCall = StatValueFactory.createStatValue((Object)0L, (String)StatDef.FailedCall.getStatName(), (Interval[])Constants.getDefaultIntervals());
        this.failDecision = StatValueFactory.createStatValue((Object)0L, (String)StatDef.FailDecision.getStatName(), (Interval[])Constants.getDefaultIntervals());
        this.retryDecision = StatValueFactory.createStatValue((Object)0L, (String)StatDef.RetryDecision.getStatName(), (Interval[])Constants.getDefaultIntervals());
        this.blackListed = StatValueFactory.createStatValue((Object)0L, (String)StatDef.Blacklisted.getStatName(), (Interval[])Constants.getDefaultIntervals());
        this.name2value.put(StatDef.RequestRoutedTo.getStatName(), this.requestRoutedTo);
        this.name2value.put(StatDef.FailedCall.getStatName(), this.failedCall);
        this.name2value.put(StatDef.FailDecision.getStatName(), this.failDecision);
        this.name2value.put(StatDef.RetryDecision.getStatName(), this.retryDecision);
        this.name2value.put(StatDef.Blacklisted.getStatName(), this.blackListed);
    }

    public String toStatsString(String s, TimeUnit timeUnit) {
        return null;
    }

    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        StatValue value = this.name2value.get(valueName);
        return value == null ? super.getValueByNameAsString(valueName, intervalName, timeUnit) : value.getValueAsString(intervalName);
    }

    public List<String> getAvailableValueNames() {
        return StatDef.getStatNames();
    }

    @Override
    public void addFailedCall() {
        this.failedCall.increase();
    }

    @Override
    public void addFailDecision() {
        this.failDecision.increase();
    }

    @Override
    public void addRetryDecision() {
        this.retryDecision.increase();
    }

    @Override
    public void addRequestRoutedTo() {
        this.requestRoutedTo.increase();
    }

    @Override
    public void addBlacklisted() {
        this.blackListed.increase();
    }

    public long getFailedCallCount(String intervalName) {
        return this.failedCall.getValueAsLong(intervalName);
    }

    public long getFailDecisionCount(String intervalName) {
        return this.failDecision.getValueAsLong(intervalName);
    }

    public long getRetryDecisionCount(String intervalName) {
        return this.retryDecision.getValueAsLong(intervalName);
    }

    public long getRequestRoutedToCount(String intervalName) {
        return this.requestRoutedTo.getValueAsLong(intervalName);
    }

    public long getBlacklistedCount(String intervalName) {
        return this.blackListed.getValueAsLong(intervalName);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        Set<Map.Entry<String, StatValue>> entries = this.name2value.entrySet();
        for (Map.Entry<String, StatValue> entry : entries) {
            if (ret.length() > 0) {
                ret.append(" ");
            }
            ret.append(entry.getKey()).append(": ").append(entry.getValue().getValueAsLong());
        }
        return ret.toString();
    }

    static {
        DecoratorRegistryFactory.getDecoratorRegistry().addDecorator(RoutingStats.class, (IDecorator)new RoutingStatsDecorator());
    }

    public static enum StatDef {
        RequestRoutedTo("RRT"),
        FailedCall("FC"),
        FailDecision("FD"),
        RetryDecision("RD"),
        Blacklisted("BL");

        private String statName;

        private StatDef(String aStatName) {
            this.statName = aStatName;
        }

        public String getStatName() {
            return this.statName;
        }

        public static List<String> getStatNames() {
            ArrayList<String> ret = new ArrayList<String>(StatDef.values().length);
            for (StatDef value : StatDef.values()) {
                ret.add(value.getStatName());
            }
            return ret;
        }

        public static StatDef getValueByName(String statName) {
            for (StatDef value : StatDef.values()) {
                if (!value.getStatName().equals(statName)) continue;
                return value;
            }
            throw new IllegalArgumentException("No such value with name: " + statName);
        }
    }
}

