/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.stats;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;
import org.distributeme.core.stats.RoutingStats;

public class RoutingStatsDecorator
extends AbstractDecorator {
    static final String[] CAPTIONS = new String[]{"RRT", "FC", "FD", "RD", "BL"};
    static final String[] SHORT_EXPLANATIONS = new String[]{"RequestRoutedTo", "Failed Call", "Fail Decision", "Retry Decision", "Blacklisted"};
    static final String[] EXPLANATIONS = new String[]{"Requests routed to this instance", "Failed calls by this instance", "Fail decision after a failed call", "Retry decision after a failed call", "Call that has been aborted due to blacklisting of an instance"};

    public RoutingStatsDecorator() {
        super("Routing", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        RoutingStats stats = (RoutingStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add((StatValueAO)new LongValueAO(CAPTIONS[i++], stats.getRequestRoutedToCount(interval)));
        ret.add((StatValueAO)new LongValueAO(CAPTIONS[i++], stats.getFailedCallCount(interval)));
        ret.add((StatValueAO)new LongValueAO(CAPTIONS[i++], stats.getFailDecisionCount(interval)));
        ret.add((StatValueAO)new LongValueAO(CAPTIONS[i++], stats.getRetryDecisionCount(interval)));
        ret.add((StatValueAO)new LongValueAO(CAPTIONS[i++], stats.getBlacklistedCount(interval)));
        return ret;
    }
}

