/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.stats;

import org.distributeme.core.stats.RoutingStats;
import org.distributeme.core.stats.RoutingStatsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingStatsWrapper
implements RoutingStatsCollector {
    private static Logger log = LoggerFactory.getLogger((String)"DistributeMeRouting");
    private RoutingStats caseStats;
    private RoutingStats defaultStats;
    private String serviceId;

    public RoutingStatsWrapper(String aServiceId, RoutingStats aCaseStats, RoutingStats aDefaultStats) {
        this.caseStats = aCaseStats;
        this.defaultStats = aDefaultStats;
        this.serviceId = aServiceId;
    }

    @Override
    public void addFailDecision() {
        if (log.isDebugEnabled()) {
            log.debug("" + this.serviceId + " - added decision to fail");
        }
        if (this.caseStats != null) {
            this.caseStats.addFailDecision();
        }
        if (this.defaultStats != null) {
            this.defaultStats.addFailDecision();
        }
    }

    @Override
    public void addFailedCall() {
        if (log.isDebugEnabled()) {
            log.debug("" + this.serviceId + " - call failed");
        }
        if (this.caseStats != null) {
            this.caseStats.addFailedCall();
        }
        if (this.defaultStats != null) {
            this.defaultStats.addFailedCall();
        }
    }

    @Override
    public void addRetryDecision() {
        if (log.isDebugEnabled()) {
            log.debug("" + this.serviceId + " - added decision to retry call");
        }
        if (this.caseStats != null) {
            this.caseStats.addRetryDecision();
        }
        if (this.defaultStats != null) {
            this.defaultStats.addRetryDecision();
        }
    }

    @Override
    public void addBlacklisted() {
        if (log.isDebugEnabled()) {
            log.debug("" + this.serviceId + " - call canceled due to blacklisting");
        }
        if (this.caseStats != null) {
            this.caseStats.addBlacklisted();
        }
        if (this.defaultStats != null) {
            this.defaultStats.addBlacklisted();
        }
    }

    @Override
    public void addRequestRoutedTo() {
        if (log.isDebugEnabled()) {
            log.debug("" + this.serviceId + " - new request will be sent to");
        }
        if (this.caseStats != null) {
            this.caseStats.addRequestRoutedTo();
        }
        if (this.defaultStats != null) {
            this.defaultStats.addRequestRoutedTo();
        }
    }
}

