/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.util;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.distributeme.core.RegistryLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRegistryUtil {
    protected static final RegistryLocation registryLocation = RegistryLocation.create();
    private static Logger LOG = LoggerFactory.getLogger(BaseRegistryUtil.class);

    protected static String encode(String urlPart) {
        try {
            return URLEncoder.encode(urlPart, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"WTF, UTF-8 is not supported?");
        }
    }

    protected static String getRegistryBaseUrl(String app) {
        return BaseRegistryUtil.getRegistryBaseUrl(app, registryLocation.getRegistryContainerHost(), registryLocation.getRegistryContainerPort());
    }

    protected static String getRegistryBaseUrl(String app, String host, int port) {
        String url = "http://" + host + ":" + port;
        url = url + "/distributeme/" + app + "/";
        return url;
    }

    protected static byte[] getUrlContent(String url) {
        return BaseRegistryUtil.getUrlContent(url, false);
    }

    protected static byte[] getUrlContent(String url, boolean silently) {
        try {
            int r;
            int expectedLength;
            URL myURL = new URL(url);
            URLConnection con = myURL.openConnection();
            InputStream inp = con.getInputStream();
            int length = expectedLength = con.getContentLength();
            if (length <= 0) {
                length = 3000;
            }
            byte[] b = new byte[length];
            byte[] result = new byte[length];
            int sum = 0;
            while ((r = inp.read(b, 0, length)) != -1) {
                System.arraycopy(b, 0, result, sum, r);
                if ((sum += r) < length) continue;
            }
            byte[] ret = new byte[sum];
            System.arraycopy(result, 0, ret, 0, sum);
            return ret;
        }
        catch (Exception e) {
            if (!silently) {
                LOG.error("getPageContent, url=" + url, (Throwable)e);
            }
            return null;
        }
    }
}

