/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.anotheria.util.StringUtils;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.conventions.WebOperations;
import org.distributeme.core.util.BaseRegistryUtil;

public class EventServiceRegistryUtil
extends BaseRegistryUtil {
    private static final char DELIMITER = ',';
    private static final List<ServiceDescriptor> EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    public static final String APP = "esregistry";

    public static final String list2string(List<ServiceDescriptor> descriptors) {
        StringBuilder ret = new StringBuilder();
        for (ServiceDescriptor d : descriptors) {
            if (ret.length() > 0) {
                ret.append(',');
            }
            ret.append(d.getSystemWideUniqueId());
        }
        return ret.toString();
    }

    public static final List<ServiceDescriptor> string2list(String encodedString) {
        String[] tokens = StringUtils.tokenize((String)encodedString, (char)',');
        ArrayList<ServiceDescriptor> ret = new ArrayList<ServiceDescriptor>();
        for (String t : tokens) {
            ret.add(ServiceDescriptor.fromSystemWideUniqueId(t));
        }
        return ret;
    }

    protected static final List<ServiceDescriptor> registerAtRegistryAs(String channelName, Target as, ServiceDescriptor descriptor) {
        String url = EventServiceRegistryUtil.getRegistryBaseUrl();
        url = url + as.getOperation().toWeb();
        url = url + "?";
        url = url + "channel=" + EventServiceRegistryUtil.encode(channelName);
        byte[] data = EventServiceRegistryUtil.getUrlContent(url = url + "&id=" + EventServiceRegistryUtil.encode(descriptor.getSystemWideUniqueId()));
        if (data == null) {
            throw new RuntimeException("Got no reply from registry");
        }
        String reply = new String(data);
        String[] tokens = StringUtils.tokenize((String)reply, (char)',');
        if (tokens.length == 0) {
            return EMPTY_LIST;
        }
        ArrayList<ServiceDescriptor> ret = new ArrayList<ServiceDescriptor>(tokens.length);
        for (String t : tokens) {
            ret.add(ServiceDescriptor.fromSystemWideUniqueId(t));
        }
        return ret;
    }

    public static final List<ServiceDescriptor> registerConsumerAtRegistryAndGetSuppliers(String channelName, ServiceDescriptor myConsumer) {
        return EventServiceRegistryUtil.registerAtRegistryAs(channelName, Target.CONSUMER, myConsumer);
    }

    public static final List<ServiceDescriptor> registerSupplierAtRegistryAndGetConsumers(String channelName, ServiceDescriptor mySupplier) {
        return EventServiceRegistryUtil.registerAtRegistryAs(channelName, Target.SUPPLIER, mySupplier);
    }

    public static final void notifyConsumerNotAvailable(ServiceDescriptor consumer) {
        EventServiceRegistryUtil.notifyNotAvailable(Target.CONSUMER, consumer);
    }

    public static final void notifySupplierNotAvailable(ServiceDescriptor supplier) {
        EventServiceRegistryUtil.notifyNotAvailable(Target.SUPPLIER, supplier);
    }

    public static final void notifyNotAvailable(Target as, ServiceDescriptor descriptor) {
        String url = EventServiceRegistryUtil.getRegistryBaseUrl();
        url = url + as.getNotifyOperation().toWeb();
        url = url + "?";
        byte[] data = EventServiceRegistryUtil.getUrlContent(url = url + "id=" + EventServiceRegistryUtil.encode(descriptor.getSystemWideUniqueId()));
        if (data == null) {
            throw new RuntimeException("Got no reply from registry");
        }
        String reply = new String(data);
        if ("ERROR".equals(reply)) {
            throw new RuntimeException("Notify failed");
        }
    }

    protected static String getRegistryBaseUrl() {
        return EventServiceRegistryUtil.getRegistryBaseUrl(APP);
    }

    protected static String getRegistryBaseUrl(String host, int port) {
        return EventServiceRegistryUtil.getRegistryBaseUrl(APP, host, port);
    }

    private static enum Target {
        CONSUMER(WebOperations.ADD_CONSUMER),
        SUPPLIER(WebOperations.ADD_SUPPLIER);

        private WebOperations operation;

        private Target(WebOperations anOperation) {
            this.operation = anOperation;
        }

        public WebOperations getOperation() {
            return this.operation;
        }

        public WebOperations getNotifyOperation() {
            switch (this.operation) {
                case ADD_CONSUMER: {
                    return WebOperations.NOTIFY_CONSUMER;
                }
                case ADD_SUPPLIER: {
                    return WebOperations.NOTIFY_SUPPLIER;
                }
            }
            throw new IllegalArgumentException("Unsupported 'as' target");
        }
    }
}

