/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.aop.aspect;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import org.aspectj.lang.ProceedingJoinPoint;

public class AbstractMoskitoAspect<S extends IStats> {
    private ConcurrentMap<String, OnDemandStatsProducer<S>> producers = new ConcurrentHashMap<String, OnDemandStatsProducer<S>>();

    protected OnDemandStatsProducer<S> getProducer(ProceedingJoinPoint pjp, String aProducerId, String aCategory, String aSubsystem, boolean withMethod, IOnDemandStatsFactory<S> factory) {
        OnDemandStatsProducer producer;
        String producerId = null;
        if (aProducerId != null && aProducerId.length() > 0) {
            producerId = aProducerId;
        } else {
            producerId = pjp.getSignature().getDeclaringTypeName();
            try {
                producerId = producerId.substring(producerId.lastIndexOf(46) + 1);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (withMethod) {
            producerId = String.valueOf(producerId) + "." + pjp.getSignature().getName();
        }
        if ((producer = (OnDemandStatsProducer)this.producers.get(producerId)) == null) {
            producer = new OnDemandStatsProducer(producerId, this.getCategory(aCategory), this.getSubsystem(aSubsystem), factory);
            OnDemandStatsProducer p = this.producers.putIfAbsent(producerId, producer);
            if (p == null) {
                ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)producer);
            } else {
                producer = p;
            }
        }
        return producer;
    }

    public String getCategory(String proposal) {
        return proposal == null || proposal.length() == 0 ? "annotated" : proposal;
    }

    public String getSubsystem(String proposal) {
        return proposal == null || proposal.length() == 0 ? "default" : proposal;
    }

    public void reset() {
        this.producers.clear();
    }
}

