/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.aop.aspect;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.aop.annotation.Accumulate;
import net.anotheria.moskito.aop.annotation.Accumulates;
import net.anotheria.moskito.aop.util.AnnotationUtils;
import net.anotheria.moskito.aop.util.MoskitoUtils;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.helper.TieableDefinition;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import org.aspectj.lang.ProceedingJoinPoint;

public class AbstractMoskitoAspect<S extends IStats> {
    private ConcurrentMap<String, OnDemandStatsProducer<S>> producers = new ConcurrentHashMap<String, OnDemandStatsProducer<S>>();

    protected OnDemandStatsProducer<S> getProducer(ProceedingJoinPoint pjp, String aProducerId, String aCategory, String aSubsystem, boolean withMethod, IOnDemandStatsFactory<S> factory, boolean tracingSupported) {
        OnDemandStatsProducer producer;
        String producerId;
        if (aProducerId != null && aProducerId.length() > 0) {
            producerId = aProducerId;
        } else {
            producerId = pjp.getSignature().getDeclaringTypeName();
            try {
                producerId = MoskitoUtils.producerName(producerId);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (withMethod) {
            producerId = String.valueOf(producerId) + "." + pjp.getSignature().getName();
        }
        if ((producer = (OnDemandStatsProducer)this.producers.get(producerId)) == null) {
            producer = new OnDemandStatsProducer(producerId, this.getCategory(aCategory), this.getSubsystem(aSubsystem), factory);
            producer.setTracingSupported(tracingSupported);
            OnDemandStatsProducer p = this.producers.putIfAbsent(producerId, producer);
            if (p == null) {
                Method[] methods;
                ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)producer);
                Class producerClass = pjp.getSignature().getDeclaringType();
                this.createClassLevelAccumulators(producer, producerClass);
                Method[] methodArray = methods = producerClass.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    this.createMethodLevelAccumulators(producer, producerClass, m);
                    ++n2;
                }
            } else {
                producer = p;
            }
        }
        return producer;
    }

    private void createMethodLevelAccumulators(OnDemandStatsProducer<S> producer, Class producerClass, Method method) {
        Accumulates accAnnotationHolderMethods = method.getAnnotation(Accumulates.class);
        if (accAnnotationHolderMethods != null && accAnnotationHolderMethods.value() != null) {
            Accumulate[] accAnnotations;
            Accumulate[] accumulateArray = accAnnotations = accAnnotationHolderMethods.value();
            int n = accAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Accumulate accAnnotation = accumulateArray[n2];
                this.createAccumulator(producer.getProducerId(), accAnnotation, this.formAccumulatorNameForMethod(producer, accAnnotation, method), method.getName());
                ++n2;
            }
        }
        this.createAccumulator(producer.getProducerId(), method.getAnnotation(Accumulate.class), this.formAccumulatorNameForMethod(producer, method.getAnnotation(Accumulate.class), method), method.getName());
    }

    private void createClassLevelAccumulators(OnDemandStatsProducer<S> producer, Class producerClass) {
        Accumulates accAnnotationHolder = AnnotationUtils.findAnnotation(producerClass, Accumulates.class);
        if (accAnnotationHolder != null && accAnnotationHolder.value() != null) {
            Accumulate[] accAnnotations;
            Accumulate[] accumulateArray = accAnnotations = accAnnotationHolder.value();
            int n = accAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Accumulate accAnnotation = accumulateArray[n2];
                this.createAccumulator(producer.getProducerId(), accAnnotation, this.formAccumulatorNameForClass(producer, accAnnotation), "cumulated");
                ++n2;
            }
        }
        Accumulate annotation = AnnotationUtils.findAnnotation(producerClass, Accumulate.class);
        this.createAccumulator(producer.getProducerId(), annotation, this.formAccumulatorNameForClass(producer, annotation), "cumulated");
    }

    private String formAccumulatorNameForMethod(OnDemandStatsProducer<S> producer, Accumulate annotation, Method m) {
        if (producer != null && annotation != null && m != null) {
            return String.valueOf(producer.getProducerId()) + "." + m.getName() + "." + annotation.valueName() + "." + annotation.intervalName();
        }
        return "";
    }

    private String formAccumulatorNameForClass(OnDemandStatsProducer<S> producer, Accumulate annotation) {
        if (producer != null && annotation != null) {
            return String.valueOf(producer.getProducerId()) + "." + annotation.valueName() + "." + annotation.intervalName();
        }
        return "";
    }

    private void createAccumulator(String producerId, Accumulate annotation, String accName, String statsName) {
        if (!(annotation == null || producerId == null || producerId.isEmpty() || accName == null || accName.isEmpty() || statsName == null || statsName.isEmpty())) {
            AccumulatorDefinition definition = new AccumulatorDefinition();
            if (annotation.name() != null && annotation.name().length() > 0) {
                definition.setName(annotation.name());
            } else {
                definition.setName(accName);
            }
            definition.setIntervalName(annotation.intervalName());
            definition.setProducerName(producerId);
            definition.setStatName(statsName);
            definition.setValueName(annotation.valueName());
            definition.setTimeUnit(annotation.timeUnit());
            AccumulatorRepository.getInstance().createAccumulator((TieableDefinition)definition);
        }
    }

    public String getCategory(String proposal) {
        return proposal == null || proposal.length() == 0 ? "annotated" : proposal;
    }

    public String getSubsystem(String proposal) {
        return proposal == null || proposal.length() == 0 ? "default" : proposal;
    }

    public void reset() {
        this.producers.clear();
    }
}

