/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.I18N;
import net.bull.javamelody.TransportFormat;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LabradorRetriever {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private static final int CONNECTION_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 60000;
    private final URL url;

    LabradorRetriever(URL url) {
        assert (url != null);
        this.url = url;
    }

    <T> T call() throws IOException {
        Serializable serializable;
        long start = System.currentTimeMillis();
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url);
            connection.setRequestProperty("Accept-Language", I18N.getCurrentLocale().toString());
            connection.connect();
            Serializable result = LabradorRetriever.read(connection);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("lu sur " + this.url + " : " + result));
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof Exception) {
                throw LabradorRetriever.createIOException((Exception)result);
            }
            serializable = result;
            Object var7_6 = null;
        }
        catch (ClassNotFoundException e) {
            try {
                throw LabradorRetriever.createIOException(e);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                LOGGER.info((Object)("appel http effectu\u00e9 en " + (System.currentTimeMillis() - start) + " ms pour " + this.url));
                throw throwable;
            }
        }
        LOGGER.info((Object)("appel http effectu\u00e9 en " + (System.currentTimeMillis() - start) + " ms pour " + this.url));
        return (T)serializable;
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTo(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        assert (httpRequest != null);
        assert (httpResponse != null);
        long start = System.currentTimeMillis();
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url);
            connection.setRequestProperty("Accept-Language", httpRequest.getHeader("Accept-Language"));
            connection.connect();
            try {
                InputStream input = connection.getInputStream();
                if ("gzip".equals(connection.getContentEncoding())) {
                    input = new GZIPInputStream(input);
                }
                httpResponse.setContentType(connection.getContentType());
                TransportFormat.pump(input, (OutputStream)httpResponse.getOutputStream());
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                LabradorRetriever.close(connection);
                throw throwable;
            }
            LabradorRetriever.close(connection);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            LOGGER.info((Object)("r\u00e9cup\u00e9ration donn\u00e9es effectu\u00e9e en " + (System.currentTimeMillis() - start) + "ms pour " + this.url));
            throw throwable;
        }
        LOGGER.info((Object)("r\u00e9cup\u00e9ration donn\u00e9es effectu\u00e9e en " + (System.currentTimeMillis() - start) + "ms pour " + this.url));
    }

    private static URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Serializable read(URLConnection connection) throws IOException, ClassNotFoundException {
        Serializable serializable;
        InputStream input = connection.getInputStream();
        try {
            String contentType;
            if ("gzip".equals(connection.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            TransportFormat transportFormat = (contentType = connection.getContentType()) != null && contentType.startsWith("text/xml") ? TransportFormat.XML : TransportFormat.SERIALIZED;
            serializable = transportFormat.readSerializableFrom(input);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            LabradorRetriever.close(connection);
            throw throwable;
        }
        LabradorRetriever.close(connection);
        return serializable;
    }

    private static void close(URLConnection connection) throws IOException {
        InputStream error;
        connection.getInputStream().close();
        if (connection instanceof HttpURLConnection && (error = ((HttpURLConnection)connection).getErrorStream()) != null) {
            error.close();
        }
    }
}

