/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import net.bull.javamelody.Counter;
import net.bull.javamelody.MonitoredWithSpring;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;

public class MonitoringSpringInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = -6594338383847482623L;
    private static final Counter SPRING_COUNTER = MonitoringProxy.getSpringCounter();
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (DISABLED || !SPRING_COUNTER.isDisplayed()) {
            return invocation.proceed();
        }
        String requestName = MonitoringSpringInterceptor.getMonitorName(invocation);
        boolean systemError = false;
        try {
            SPRING_COUNTER.bindContextIncludingCpu(requestName);
            Object object = invocation.proceed();
            Object var6_6 = null;
            SPRING_COUNTER.addRequestForCurrentContext(systemError);
            return object;
        }
        catch (Error e) {
            try {
                systemError = true;
                throw e;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                SPRING_COUNTER.addRequestForCurrentContext(systemError);
                throw throwable;
            }
        }
    }

    private static String getMonitorName(MethodInvocation invocation) {
        String classPart = MonitoringSpringInterceptor.getClassPart(invocation);
        String methodPart = MonitoringSpringInterceptor.getMethodPart(invocation);
        return classPart + '.' + methodPart;
    }

    private static String getClassPart(MethodInvocation invocation) {
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getThis());
        MonitoredWithSpring classAnnotation = targetClass.getAnnotation(MonitoredWithSpring.class);
        if (classAnnotation == null || classAnnotation.name() == null || classAnnotation.name().length() == 0) {
            return targetClass.getSimpleName();
        }
        return classAnnotation.name();
    }

    private static String getMethodPart(MethodInvocation invocation) {
        MonitoredWithSpring methodAnnotation = invocation.getMethod().getAnnotation(MonitoredWithSpring.class);
        if (methodAnnotation == null || methodAnnotation.name() == null || methodAnnotation.name().length() == 0) {
            return invocation.getMethod().getName();
        }
        return methodAnnotation.name();
    }
}

