/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessInformations
implements Serializable {
    static final boolean WINDOWS = System.getProperty("os.name").toLowerCase(Locale.getDefault()).contains("windows");
    private static final long serialVersionUID = 2163916067335213382L;
    private static final Pattern WINDOWS_STATE_PATTERN = Pattern.compile("................");
    private static final Pattern WINDOWS_CPU_TIME_PATTERN = Pattern.compile("[0-9:]*");
    private final String user;
    private final int pid;
    private final float cpuPercentage;
    private final float memPercentage;
    private final int vsz;
    private final int rss;
    private final String tty;
    private final String stat;
    private final String start;
    private final String cpuTime;
    private final String command;

    private ProcessInformations(Scanner sc, boolean windows) {
        if (windows) {
            StringBuilder imageNameBuilder = new StringBuilder(sc.next());
            while (!sc.hasNextInt()) {
                imageNameBuilder.append(' ').append(sc.next());
            }
            this.pid = sc.nextInt();
            if ("Console".equals(sc.next())) {
                sc.next();
            }
            String memory = sc.next();
            this.cpuPercentage = -1.0f;
            this.memPercentage = -1.0f;
            this.vsz = Integer.parseInt(memory.replace(",", "").replace("\u00ff", ""));
            this.rss = -1;
            this.tty = null;
            sc.next();
            sc.skip(WINDOWS_STATE_PATTERN);
            this.stat = null;
            StringBuilder userBuilder = new StringBuilder(sc.next());
            while (!sc.hasNext(WINDOWS_CPU_TIME_PATTERN)) {
                userBuilder.append(' ').append(sc.next());
            }
            this.user = userBuilder.toString();
            this.start = null;
            this.cpuTime = sc.next();
            this.command = imageNameBuilder.append("   (").append(sc.nextLine().trim()).append(')').toString();
        } else {
            this.user = sc.next();
            this.pid = sc.nextInt();
            this.cpuPercentage = sc.nextFloat();
            this.memPercentage = sc.nextFloat();
            this.vsz = sc.nextInt();
            this.rss = sc.nextInt();
            this.tty = sc.next();
            this.stat = sc.next();
            this.start = sc.next();
            this.cpuTime = sc.next();
            this.command = sc.nextLine();
        }
    }

    static List<ProcessInformations> buildProcessInformations(InputStream in, boolean windows) {
        String charset = windows ? "Cp1252" : "UTF-8";
        Scanner sc = new Scanner(in, charset);
        sc.useRadix(10);
        sc.useLocale(Locale.US);
        sc.nextLine();
        if (windows) {
            sc.nextLine();
            sc.nextLine();
        }
        ArrayList<ProcessInformations> processInfos = new ArrayList<ProcessInformations>();
        while (sc.hasNext()) {
            ProcessInformations processInfo = new ProcessInformations(sc, windows);
            processInfos.add(processInfo);
        }
        return Collections.unmodifiableList(processInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ProcessInformations> buildProcessInformations() throws IOException {
        Process process = null;
        try {
            process = WINDOWS ? Runtime.getRuntime().exec(new String[]{"cmd", "/c", "tasklist /V"}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "ps wauxf"});
            List<ProcessInformations> list = ProcessInformations.buildProcessInformations(process.getInputStream(), WINDOWS);
            return list;
        }
        finally {
            if (process != null) {
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
                process.destroy();
            }
        }
    }

    String getUser() {
        return this.user;
    }

    int getPid() {
        return this.pid;
    }

    float getCpuPercentage() {
        return this.cpuPercentage;
    }

    float getMemPercentage() {
        return this.memPercentage;
    }

    int getVsz() {
        return this.vsz;
    }

    int getRss() {
        return this.rss;
    }

    String getTty() {
        return this.tty;
    }

    String getStat() {
        return this.stat;
    }

    String getStart() {
        return this.start;
    }

    String getCpuTime() {
        return this.cpuTime;
    }

    String getCommand() {
        return this.command;
    }
}

