/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import net.bull.javamelody.I18N;

abstract class HtmlAbstractReport {
    private static final boolean PDF_ENABLED = HtmlAbstractReport.computePdfEnabled();
    private final Writer writer;

    HtmlAbstractReport(Writer writer) {
        assert (writer != null);
        this.writer = writer;
    }

    abstract void toHtml() throws IOException;

    Writer getWriter() {
        return this.writer;
    }

    void writeDirectly(String html) throws IOException {
        this.writer.write(html);
    }

    void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    static String getString(String key) {
        return I18N.getString(key);
    }

    static String getStringForJavascript(String key) {
        return I18N.getStringForJavascript(key);
    }

    static String getFormattedString(String key, Object ... arguments) {
        return I18N.getFormattedString(key, arguments);
    }

    static String javascriptEncode(String text) {
        return I18N.javascriptEncode(text);
    }

    static String urlEncode(String text) {
        return I18N.urlEncode(text);
    }

    static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    static String htmlEncodeButNotSpace(String text) {
        return I18N.htmlEncode(text, false);
    }

    static boolean isPdfEnabled() {
        return PDF_ENABLED;
    }

    private static boolean computePdfEnabled() {
        try {
            Class.forName("com.lowagie.text.Document");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

