/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import net.bull.javamelody.LoggingHandler;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class Log4JAppender
extends AppenderSkeleton {
    private static final String MESSAGE_PATTERN = "%-5p [%c] %m%n";
    private static final Level THRESHOLD = Level.WARN;
    private static final Log4JAppender SINGLETON = new Log4JAppender();

    public Log4JAppender() {
        this.setLayout((Layout)new PatternLayout(MESSAGE_PATTERN));
        this.setThreshold((Priority)THRESHOLD);
        this.setName(((Object)((Object)this)).getClass().getName());
    }

    static Log4JAppender getSingleton() {
        return SINGLETON;
    }

    void register() {
        Logger.getRootLogger().addAppender((Appender)this);
    }

    void deregister() {
        Logger.getRootLogger().removeAppender((Appender)this);
    }

    protected void append(LoggingEvent event) {
        Throwable throwable = event.getThrowableInformation() == null ? null : event.getThrowableInformation().getThrowable();
        LoggingHandler.addErrorLogToCounter(this.getLayout().format(event), throwable);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

