/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.PdfAbstractReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfJndiReport
extends PdfAbstractReport {
    private final List<JndiBinding> jndiBindings;
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private PdfPTable currentTable;

    PdfJndiReport(List<JndiBinding> jndiBindings, Document document) {
        super(document);
        assert (jndiBindings != null);
        this.jndiBindings = jndiBindings;
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        this.writeHeader();
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (JndiBinding jndiBinding : this.jndiBindings) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeJndiBinding(jndiBinding);
        }
        this.addToDocument((Element)this.currentTable);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfJndiReport.getString("Nom"));
        headers.add(PdfJndiReport.getString("Type"));
        return headers;
    }

    private void writeJndiBinding(JndiBinding jndiBinding) throws BadElementException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        String name = jndiBinding.getName();
        String className = jndiBinding.getClassName();
        String contextPath = jndiBinding.getContextPath();
        if (contextPath != null) {
            Image image = PdfDocumentFactory.getImage("folder.png");
            image.scalePercent(40.0f);
            Phrase phrase = new Phrase("", this.cellFont);
            phrase.add((Object)new Chunk(image, 0.0f, 0.0f));
            phrase.add((Object)" ");
            phrase.add((Object)name);
            this.currentTable.addCell(phrase);
        } else {
            this.addCell(name);
        }
        this.addCell(className != null ? className : "");
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

