/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.HtmlProcessInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfAbstractReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.ProcessInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfProcessInformationsReport
extends PdfAbstractReport {
    private final List<ProcessInformations> processInformationsList;
    private final boolean windows;
    private final DecimalFormat percentFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private PdfPTable currentTable;

    PdfProcessInformationsReport(List<ProcessInformations> processInformationsList, Document document) {
        super(document);
        assert (processInformationsList != null);
        this.processInformationsList = processInformationsList;
        this.windows = HtmlProcessInformationsReport.isWindowsProcessList(processInformationsList);
    }

    @Override
    void toPdf() throws DocumentException {
        this.writeHeader();
        this.writeProcessInformations();
        if (!this.windows) {
            this.addPsCommandReference();
        }
    }

    private void addPsCommandReference() throws DocumentException {
        Anchor psAnchor = new Anchor("ps command reference", PdfFonts.BLUE.getFont());
        psAnchor.setName("ps command reference");
        psAnchor.setReference("http://en.wikipedia.org/wiki/Ps_(Unix)");
        psAnchor.setFont(PdfFonts.BLUE.getFont());
        Paragraph psParagraph = new Paragraph();
        psParagraph.add((Object)psAnchor);
        psParagraph.setAlignment(2);
        this.addToDocument((Element)psParagraph);
    }

    private void writeProcessInformations() throws DocumentException {
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (ProcessInformations processInformations : this.processInformationsList) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeProcessInformations(processInformations);
        }
        this.addToDocument((Element)this.currentTable);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        if (this.windows) {
            relativeWidths[0] = 2;
        }
        relativeWidths[headers.size() - 1] = 6;
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfProcessInformationsReport.getString("Utilisateur"));
        headers.add(PdfProcessInformationsReport.getString("PID"));
        if (!this.windows) {
            headers.add(PdfProcessInformationsReport.getString("cpu"));
            headers.add(PdfProcessInformationsReport.getString("mem"));
        }
        headers.add(PdfProcessInformationsReport.getString("vsz"));
        if (!this.windows) {
            headers.add(PdfProcessInformationsReport.getString("rss"));
            headers.add(PdfProcessInformationsReport.getString("tty"));
            headers.add(PdfProcessInformationsReport.getString("stat"));
            headers.add(PdfProcessInformationsReport.getString("start"));
        }
        headers.add(PdfProcessInformationsReport.getString("cpuTime"));
        headers.add(PdfProcessInformationsReport.getString("command"));
        return headers;
    }

    private void writeProcessInformations(ProcessInformations processInformations) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(processInformations.getUser());
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.integerFormat.format(processInformations.getPid()));
        if (!this.windows) {
            this.addCell(this.percentFormat.format(processInformations.getCpuPercentage()));
            this.addCell(this.percentFormat.format(processInformations.getMemPercentage()));
        }
        this.addCell(this.integerFormat.format(processInformations.getVsz()));
        if (!this.windows) {
            this.addCell(this.integerFormat.format(processInformations.getRss()));
            defaultCell.setHorizontalAlignment(0);
            this.addCell(processInformations.getTty());
            this.addCell(processInformations.getStat());
            defaultCell.setHorizontalAlignment(2);
            this.addCell(processInformations.getStart());
        }
        this.addCell(processInformations.getCpuTime());
        defaultCell.setHorizontalAlignment(0);
        this.addCell(processInformations.getCommand());
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

