/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import net.bull.javamelody.internal.common.Parameters;

public class JndiBinding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JNDI_PREFIX = "java:";
    private final String name;
    private final String className;
    private final String contextPath;
    private final String value;

    JndiBinding(String name, String className, String contextPath, String value) {
        this.name = name;
        this.className = className;
        this.contextPath = contextPath;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public static String normalizePath(String path) {
        if (path != null) {
            return path;
        }
        if (Parameters.getServletContext().getServerInfo().contains("GlassFish")) {
            return "comp";
        }
        return "";
    }

    public static List<JndiBinding> listBindings(String path) throws NamingException {
        return JndiBinding.listBindings(new InitialContext(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JndiBinding> listBindings(Context context, String path) throws NamingException {
        String normalizedPath = JndiBinding.normalizePath(path);
        String jndiName = Parameters.getServletContext().getServerInfo().contains("WebLogic") ? JNDI_PREFIX + normalizedPath + '/' : JNDI_PREFIX + normalizedPath;
        ArrayList<JndiBinding> result = new ArrayList<JndiBinding>();
        NamingEnumeration<Binding> enumeration = context.listBindings(jndiName);
        try {
            while (enumeration.hasMore()) {
                try {
                    Binding binding = enumeration.next();
                    JndiBinding jndiBinding = JndiBinding.createJndiBinding(normalizedPath, binding);
                    result.add(jndiBinding);
                }
                catch (Exception e) {}
            }
        }
        finally {
            context.close();
        }
        return result;
    }

    private static JndiBinding createJndiBinding(String path, Binding binding) {
        String value;
        String contextPath;
        String name = JndiBinding.getBindingName(path, binding);
        String className = binding.getClassName();
        Object object = binding.getObject();
        if (object instanceof Context || "javax.naming.Context".equals(className) || object instanceof Reference && "javax.naming.Context".equals(((Reference)object).getClassName())) {
            contextPath = !path.isEmpty() ? path + '/' + name : name;
            value = null;
        } else {
            contextPath = null;
            value = JndiBinding.formatValue(object);
        }
        return new JndiBinding(name, className, contextPath, value);
    }

    private static String formatValue(Object object) {
        String value;
        try {
            if (object instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                boolean first = true;
                for (Object aItem : (Collection)object) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",\n");
                    }
                    sb.append(String.valueOf(aItem));
                }
                sb.append(']');
                value = sb.toString();
            } else {
                value = String.valueOf(object);
            }
        }
        catch (Exception e) {
            value = e.toString();
        }
        return value;
    }

    private static String getBindingName(String path, Binding binding) {
        String result = binding.getName();
        if (result.startsWith(JNDI_PREFIX)) {
            result = result.substring(JNDI_PREFIX.length());
        }
        if (result.startsWith(path)) {
            result = result.substring(path.length());
        }
        if (!result.isEmpty() && result.charAt(0) == '/') {
            result = result.substring(1);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", className=" + this.getClassName() + ", contextPath=" + this.getContextPath() + ']';
    }
}

