/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;

class HtmlConnectionInformationsReport
extends HtmlAbstractReport {
    private final List<ConnectionInformations> connectionsInformations;
    private final DateFormat dateTimeFormat = I18N.createDateAndTimeFormat();
    private final Map<Long, Thread> threadsById;
    private final Map<Thread, StackTraceElement[]> stackTracesByThread;

    HtmlConnectionInformationsReport(List<ConnectionInformations> connectionsInformations, Writer writer) {
        super(writer);
        assert (connectionsInformations != null);
        this.connectionsInformations = connectionsInformations;
        this.stackTracesByThread = Thread.getAllStackTraces();
        this.threadsById = new HashMap<Long, Thread>(this.stackTracesByThread.size());
        for (Thread thread : this.stackTracesByThread.keySet()) {
            this.threadsById.put(thread.getId(), thread);
        }
    }

    @Override
    void toHtml() throws IOException {
        this.writeBackAndRefreshLinks();
        this.writeln("<br/>");
        this.writeTitle("db.png", HtmlConnectionInformationsReport.getString("Connexions_jdbc_ouvertes"));
        this.writeln("<br/>#connexions_intro#<br/><br/>");
        this.writeConnections();
    }

    void writeConnections() throws IOException {
        if (this.connectionsInformations.isEmpty()) {
            this.writeln("#Aucune_connexion_jdbc_ouverte#");
            return;
        }
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlConnectionInformationsReport.getString("Connexions_jdbc_ouvertes"));
        this.write("<th class='sorttable_date'>#Date_et_stack_trace_ouverture#</th>");
        this.write("<th>#Thread_et_stack_trace_actuelle#</th>");
        for (ConnectionInformations connection : this.connectionsInformations) {
            table.nextRow();
            this.writeConnection(connection);
        }
        table.endTable();
        int nbConnections = this.connectionsInformations.size();
        this.writeln("<div align='right'>" + HtmlConnectionInformationsReport.getFormattedString("nb_connexions_ouvertes", nbConnections) + "</div>");
    }

    private void writeBackAndRefreshLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'>");
        this.writeln("<img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=connections'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private void writeConnection(ConnectionInformations connection) throws IOException {
        this.write("<td align='right'>");
        this.writeTextWithStackTrace(this.dateTimeFormat.format(connection.getOpeningDate()), connection.getOpeningStackTrace());
        this.write("</td><td>");
        Thread thread = this.threadsById.get(connection.getThreadId());
        if (thread == null) {
            this.write("&nbsp;");
        } else {
            StackTraceElement[] stackTrace = this.stackTracesByThread.get(thread);
            this.writeTextWithStackTrace(thread.getName(), stackTrace != null ? Arrays.asList(stackTrace) : null);
        }
        this.write("</td>");
    }

    private void writeTextWithStackTrace(String text, List<StackTraceElement> stackTrace) throws IOException {
        String encodedText = HtmlConnectionInformationsReport.htmlEncode(text);
        if (stackTrace != null && !stackTrace.isEmpty()) {
            this.writeln("<div class='tooltip'>");
            this.writeln("<em>");
            this.writeDirectly(encodedText);
            this.writeln("<br/>");
            for (StackTraceElement stackTraceElement : stackTrace) {
                this.writeDirectly(HtmlSourceReport.htmlEncodeStackTraceElement(stackTraceElement.toString()));
                this.writeDirectly("<br/>");
            }
            this.writeln("</em>");
            this.writeDirectly(encodedText);
            this.writeln("</div>");
        } else {
            this.writeDirectly(encodedText);
        }
    }
}

