/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.config.CacheConfiguration;

class CacheInformations
implements Serializable {
    private static final long serialVersionUID = -3025833425994923286L;
    private static final boolean EHCACHE_1_6 = CacheInformations.isEhcache16();
    private static final boolean EHCACHE_1_2 = CacheInformations.isEhcache12();
    private static final boolean EHCACHE_1_2_X = CacheInformations.isEhcache12x();
    private final String name;
    private final long inMemoryObjectCount;
    private final long onDiskObjectCount;
    private final long inMemoryHits;
    private final long cacheHits;
    private final long cacheMisses;
    private final String configuration;

    CacheInformations(Ehcache cache) {
        String tmpConfiguration;
        long tmpCacheMisses;
        long tmpCacheHits;
        long tmpInMemoryHits;
        long tmpOnDiskObjectCount;
        long tmpInMemoryObjectCount;
        assert (cache != null);
        Statistics statistics = cache.getStatistics();
        assert (statistics != null);
        this.name = cache.getName();
        if (EHCACHE_1_6) {
            tmpInMemoryObjectCount = statistics.getMemoryStoreObjectCount();
            tmpOnDiskObjectCount = statistics.getDiskStoreObjectCount();
            assert (statistics.getStatisticsAccuracy() == 1);
        } else {
            tmpInMemoryObjectCount = cache.getMemoryStoreSize();
            tmpOnDiskObjectCount = cache.getDiskStoreSize();
        }
        this.inMemoryObjectCount = tmpInMemoryObjectCount;
        this.onDiskObjectCount = tmpOnDiskObjectCount;
        if (EHCACHE_1_2_X) {
            tmpInMemoryHits = CacheInformations.invokeStatisticsMethod(statistics, "getInMemoryHits");
            tmpCacheHits = CacheInformations.invokeStatisticsMethod(statistics, "getCacheHits");
            tmpCacheMisses = CacheInformations.invokeStatisticsMethod(statistics, "getCacheMisses");
            tmpConfiguration = null;
        } else if (EHCACHE_1_2) {
            tmpInMemoryHits = -1L;
            tmpCacheHits = -1L;
            tmpCacheMisses = -1L;
            tmpConfiguration = null;
        } else {
            tmpInMemoryHits = statistics.getInMemoryHits();
            tmpCacheHits = statistics.getCacheHits();
            tmpCacheMisses = statistics.getCacheMisses();
            tmpConfiguration = CacheInformations.buildConfiguration(cache);
        }
        this.inMemoryHits = tmpInMemoryHits;
        this.cacheHits = tmpCacheHits;
        this.cacheMisses = tmpCacheMisses;
        this.configuration = tmpConfiguration;
    }

    private static long invokeStatisticsMethod(Statistics statistics, String methodName) {
        try {
            Number result = (Number)Statistics.class.getMethod(methodName, null).invoke((Object)statistics, (Object[])null);
            return result.longValue();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isEhcache16() {
        try {
            Statistics.class.getMethod("getMemoryStoreObjectCount", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean isEhcache12() {
        try {
            Ehcache.class.getMethod("getCacheConfiguration", new Class[0]);
            return false;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private static boolean isEhcache12x() {
        try {
            Class.forName("net.sf.ehcache.Statistics");
            return CacheInformations.isEhcache12();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String buildConfiguration(Ehcache cache) {
        StringBuilder sb = new StringBuilder();
        CacheConfiguration configuration = cache.getCacheConfiguration();
        sb.append("ehcache [maxElementsInMemory = ").append(configuration.getMaxElementsInMemory());
        boolean overflowToDisk = configuration.isOverflowToDisk();
        sb.append(", overflowToDisk = ").append(overflowToDisk);
        if (overflowToDisk) {
            sb.append(", maxElementsOnDisk = ").append(configuration.getMaxElementsOnDisk());
        }
        boolean eternal = configuration.isEternal();
        sb.append(", eternal = ").append(eternal);
        if (!eternal) {
            sb.append(", timeToLiveSeconds = ").append(configuration.getTimeToLiveSeconds());
            sb.append(", timeToIdleSeconds = ").append(configuration.getTimeToIdleSeconds());
            sb.append(", memoryStoreEvictionPolicy = ").append(configuration.getMemoryStoreEvictionPolicy());
        }
        sb.append(", diskPersistent = ").append(configuration.isDiskPersistent());
        sb.append(']');
        return sb.toString();
    }

    String getName() {
        return this.name;
    }

    long getInMemoryObjectCount() {
        return this.inMemoryObjectCount;
    }

    long getOnDiskObjectCount() {
        return this.onDiskObjectCount;
    }

    int getInMemoryHitsRatio() {
        if (this.cacheHits == 0L) {
            return -1;
        }
        return (int)(100L * this.inMemoryHits / this.cacheHits);
    }

    int getHitsRatio() {
        long accessCount = this.cacheHits + this.cacheMisses;
        if (accessCount == 0L) {
            return -1;
        }
        return (int)(100L * this.cacheHits / accessCount);
    }

    String getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", inMemoryObjectCount=" + this.getInMemoryObjectCount() + ", onDiskObjectCount=" + this.getOnDiskObjectCount() + ", inMemoryHitsRatio=" + this.getInMemoryHitsRatio() + ", hitsRatio=" + this.getHitsRatio() + ']';
    }
}

