/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

class CounterError
implements Serializable {
    static final String REQUEST_KEY = "javamelody.request";
    private static final long serialVersionUID = 5690702786722045646L;
    private static final ThreadLocal<HttpServletRequest> HTTP_SERVLET_REQUEST_CONTEXT = new ThreadLocal();
    private final long time;
    private final String remoteUser;
    private final String httpRequest;
    private final String message;
    private final String stackTrace;

    CounterError(String message, String stackTrace) {
        assert (message != null);
        this.time = System.currentTimeMillis();
        this.message = message;
        this.stackTrace = stackTrace;
        HttpServletRequest currentRequest = CounterError.getCurrentRequest();
        if (currentRequest == null) {
            this.remoteUser = null;
            this.httpRequest = null;
        } else {
            this.remoteUser = currentRequest.getRemoteUser();
            this.httpRequest = (String)currentRequest.getAttribute(REQUEST_KEY);
        }
    }

    static void bindRequest(HttpServletRequest request) {
        if (request != null) {
            HTTP_SERVLET_REQUEST_CONTEXT.set(request);
        }
    }

    private static HttpServletRequest getCurrentRequest() {
        return HTTP_SERVLET_REQUEST_CONTEXT.get();
    }

    static void unbindRequest() {
        HTTP_SERVLET_REQUEST_CONTEXT.remove();
    }

    long getTime() {
        return this.time;
    }

    Date getDate() {
        return new Date(this.time);
    }

    String getRemoteUser() {
        return this.remoteUser;
    }

    String getHttpRequest() {
        return this.httpRequest;
    }

    String getMessage() {
        return this.message;
    }

    String getStackTrace() {
        return this.stackTrace;
    }
}

