/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;

final class JspWrapper
implements InvocationHandler {
    private static final Counter JSP_COUNTER = new Counter("jsp", "jsp.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(JSP_COUNTER.getName());
    private static final boolean DISABLED = Parameter.DISABLED.getValueAsBoolean();
    private final String path;
    private final RequestDispatcher requestDispatcher;

    JspWrapper(String path, RequestDispatcher requestDispatcher) {
        assert (path != null);
        assert (requestDispatcher != null);
        JSP_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        JSP_COUNTER.setUsed(true);
        this.path = path;
        this.requestDispatcher = requestDispatcher;
    }

    static HttpServletRequest createHttpRequestWrapper(HttpServletRequest request, HttpServletResponse response) {
        if (DISABLED || COUNTER_HIDDEN) {
            return request;
        }
        return new HttpRequestWrapper(request, response);
    }

    static Counter getJspCounter() {
        return JSP_COUNTER;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("include" != methodName && "forward" != methodName) {
            return method.invoke((Object)this.requestDispatcher, args);
        }
        boolean systemError = false;
        try {
            int indexOf = this.path.indexOf(63);
            String pathWithoutParameters = indexOf != -1 ? this.path.substring(0, indexOf) : this.path;
            JSP_COUNTER.bindContextIncludingCpu(pathWithoutParameters);
            Object object = method.invoke((Object)this.requestDispatcher, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                systemError = true;
            }
            throw e;
        }
        finally {
            JSP_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    private static class HttpRequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpServletResponse response;

        HttpRequestWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(request);
            this.response = response;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            RequestDispatcher requestDispatcher = super.getRequestDispatcher(path);
            if (requestDispatcher == null) {
                return null;
            }
            JspWrapper invocationHandler = new JspWrapper(String.valueOf(path), requestDispatcher);
            return JdbcWrapper.createProxy(requestDispatcher, invocationHandler);
        }

        public AsyncContext startAsync() {
            return super.startAsync((ServletRequest)this, (ServletResponse)this.response);
        }
    }
}

