/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.internal.model.Counter;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class SpringRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    static final ClientHttpRequestInterceptor SINGLETON = new SpringRestTemplateInterceptor();
    private static final Counter SPRING_COUNTER = MonitoringProxy.getSpringCounter();

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (!SPRING_COUNTER.isDisplayed()) {
            return execution.execute(httpRequest, body);
        }
        String requestName = this.getRequestName(httpRequest);
        boolean systemError = false;
        try {
            SPRING_COUNTER.bindContextIncludingCpu(requestName);
            ClientHttpResponse clientHttpResponse = execution.execute(httpRequest, body);
            return clientHttpResponse;
        }
        catch (IOException | Error e) {
            systemError = true;
            throw e;
        }
        finally {
            SPRING_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    protected String getRequestName(HttpRequest httpRequest) {
        String uri = httpRequest.getURI().toString();
        int index = uri.indexOf(63);
        if (index != -1) {
            uri = uri.substring(0, index);
        }
        return uri + " " + httpRequest.getMethod();
    }
}

