/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.publish;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.net.SocketFactory;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.publish.MetricsPublisher;

class Graphite
extends MetricsPublisher {
    private static final int DEFAULT_GRAPHITE_PORT = 2003;
    private static final char SEPARATOR = ' ';
    private final SocketFactory socketFactory;
    private final InetAddress address;
    private final int port;
    private final String prefix;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Writer bufferWriter;
    private long lastTime;
    private String lastTimestamp;

    Graphite(SocketFactory socketFactory, InetAddress address, int port, Charset charset, String prefix) {
        assert (socketFactory != null);
        assert (address != null);
        assert (charset != null);
        assert (prefix != null);
        this.socketFactory = socketFactory;
        this.address = address;
        this.port = port;
        this.prefix = prefix;
        this.bufferWriter = new OutputStreamWriter((OutputStream)this.buffer, charset);
    }

    static Graphite getInstance(String contextPath, String hostName) {
        String graphiteAddress = Parameter.GRAPHITE_ADDRESS.getValue();
        if (graphiteAddress != null) {
            int port;
            String address;
            assert (contextPath != null);
            assert (hostName != null);
            int index = graphiteAddress.lastIndexOf(58);
            if (index != -1) {
                address = graphiteAddress.substring(0, index);
                port = Integer.parseInt(graphiteAddress.substring(index + 1));
            } else {
                address = graphiteAddress;
                port = 2003;
            }
            String prefix = ("javamelody." + contextPath.replace("/", "") + "." + hostName.replace('.', '_') + ".").replace(' ', '_');
            try {
                return new Graphite(SocketFactory.getDefault(), InetAddress.getByName(address), port, StandardCharsets.UTF_8, prefix);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid host: " + address, e);
            }
        }
        return null;
    }

    @Override
    public synchronized void addValue(String metric, double value) throws IOException {
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        if (this.lastTime != timeInSeconds) {
            this.lastTimestamp = String.valueOf(timeInSeconds);
            this.lastTime = timeInSeconds;
        }
        this.bufferWriter.append(this.prefix).append(metric).append(' ');
        this.bufferWriter.append(this.decimalFormat.format(value)).append(' ');
        this.bufferWriter.append(this.lastTimestamp).append('\n');
    }

    @Override
    public synchronized void send() throws IOException {
        try {
            this.bufferWriter.flush();
            try (Socket socket = this.createSocket();){
                this.buffer.writeTo(socket.getOutputStream());
                this.checkNoReturnedData(socket);
            }
        }
        catch (ConnectException e) {
            throw new IOException("Error connecting to Graphite at " + this.address + ":" + this.port, e);
        }
        finally {
            this.buffer.reset();
        }
    }

    private Socket createSocket() throws IOException {
        return this.socketFactory.createSocket(this.address, this.port);
    }

    private void checkNoReturnedData(Socket socket) throws IOException {
        int toRead;
        byte[] bytes;
        int read;
        InputStream input = socket.getInputStream();
        if (input.available() > 0 && (read = input.read(bytes = new byte[1000], 0, toRead = Math.min(input.available(), bytes.length))) > 0) {
            String msg = "Data returned by graphite server when expecting no response! Probably aimed at wrong socket or server. Make sure you are publishing to the data port, not the dashboard port. First " + read + " bytes of response: " + new String(bytes, 0, read, StandardCharsets.UTF_8);
            LOG.warn(msg, new IOException(msg));
        }
    }

    @Override
    public void stop() {
    }
}

