/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.publish;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.publish.MetricsPublisher;

class Statsd
extends MetricsPublisher {
    private static final int DEFAULT_STATSD_PORT = 8125;
    private static final int SOCKET_BUFFER_SIZE = 4096;
    private final InetSocketAddress address;
    private final String prefix;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Writer bufferWriter = new OutputStreamWriter((OutputStream)this.buffer, StandardCharsets.UTF_8);

    Statsd(InetAddress host, int port, String prefix) {
        this.address = new InetSocketAddress(host, port);
        this.prefix = prefix;
    }

    static Statsd getInstance(String contextPath, String hostName) {
        String statsdAddress = Parameter.STATSD_ADDRESS.getValue();
        if (statsdAddress != null) {
            int port;
            String address;
            assert (contextPath != null);
            assert (hostName != null);
            int index = statsdAddress.lastIndexOf(58);
            if (index != -1) {
                address = statsdAddress.substring(0, index);
                port = Integer.parseInt(statsdAddress.substring(index + 1));
            } else {
                address = statsdAddress;
                port = 8125;
            }
            Object statsdPrefix = Parameter.STATSD_PREFIX.getValue();
            if (statsdPrefix == null) {
                statsdPrefix = "javamelody." + contextPath.replace("/", "") + "." + hostName + ".";
            }
            try {
                return new Statsd(InetAddress.getByName(address), port, (String)statsdPrefix);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid host: " + address, e);
            }
        }
        return null;
    }

    @Override
    public synchronized void addValue(String metric, double value) throws IOException {
        this.bufferWriter.append(this.prefix).append(metric).append(':');
        this.bufferWriter.append(this.decimalFormat.format(value)).append("|g\n");
    }

    @Override
    public synchronized void send() throws IOException {
        try {
            this.bufferWriter.flush();
            byte[] bytes = this.buffer.toByteArray();
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            try (DatagramChannel channel = this.createDatagramChannel();){
                int nbSentBytes = channel.send(byteBuffer, this.address);
                if (bytes.length != nbSentBytes) {
                    String msg = String.format("Could not send entirely data to StatsD host %s:%d. Only sent %d bytes out of %d bytes", this.address.getHostName(), this.address.getPort(), nbSentBytes, bytes.length);
                    LOG.warn(msg, new IOException(msg));
                }
            }
        }
        catch (ConnectException e) {
            throw new IOException("Error connecting to StatsD at " + this.address.getHostName() + ":" + this.address.getPort(), e);
        }
        finally {
            this.buffer.reset();
        }
    }

    private DatagramChannel createDatagramChannel() throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)4096);
        return channel;
    }

    @Override
    public void stop() {
    }
}

