/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.bull.javamelody.SpringContext;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;

public class HtmlSpringContextReport
extends HtmlAbstractReport {
    private final SpringContext springContext;

    HtmlSpringContextReport(SpringContext springContext, Writer writer) {
        super(writer);
        assert (springContext != null);
        this.springContext = springContext;
    }

    @Override
    void toHtml() throws IOException {
        this.writeBackLink();
        this.writeln("<br/>");
        List<String> beanDefinitionNames = this.springContext.getBeanDefinitionNames();
        this.writeTitle("beans.png", HtmlSpringContextReport.getString("Spring_beans"));
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlSpringContextReport.getString("Spring_beans"));
        this.write("<th>#Nom#</th><th>#Classe#</th><th>Bean</th>");
        for (String beanName : beanDefinitionNames) {
            String beanToString;
            table.nextRow();
            Object bean = this.springContext.getBean(beanName);
            Class<?> beanClass = bean.getClass();
            try {
                beanToString = bean.toString();
            }
            catch (Exception e) {
                beanToString = e.toString();
            }
            this.writeBean(beanName, beanClass, beanToString);
        }
        table.endTable();
        this.writeln("<div align='right'>" + HtmlSpringContextReport.getFormattedString("nb_beans", beanDefinitionNames.size()) + "</div>");
    }

    private void writeBackLink() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a class='back' href=''><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("</div>");
    }

    private void writeBean(String beanName, Class<?> beanClass, String beanToString) throws IOException {
        this.write("<td class='wrappedText'>");
        this.writeDirectly(HtmlSpringContextReport.htmlEncodeButNotSpace(beanName));
        this.write("</td><td class='wrappedText'>");
        this.writeDirectly(HtmlSourceReport.addLinkToClassName(beanClass.getName()));
        this.write("</td><td class='wrappedText'>");
        this.writeDirectly(HtmlSpringContextReport.htmlEncodeButNotSpace(beanToString));
        this.write("</td>");
    }
}

