/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

final class JavaHTMLizer {
    private static final String BR = "<br />\n";
    private static final List<Pattern> RESERVED_WORDS_PATTERNS = JavaHTMLizer.createReservedWordPatterns(List.of("class", "finally", "return", "new", "public", "static", "final", "void", "synchronized", "interface", "enum", "private", "protected", "import", "package", "try", "catch", "for", "while", "do", "if", "else", "switch", "case", "default", "goto", "byte", "short", "int", "long", "float", "double", "char", "boolean", "extends", "implements", "super", "this", "true", "false", "null", "abstract", "break", "continue", "assert", "instanceof", "native", "strictfp", "throws", "throw", "transient", "volatile"));
    private static final Map<Character, String> ESCAPE_MAPS = JavaHTMLizer.createEscapeMaps();
    private static final Pattern MULTILINE_COMMENT_PATTERN = Pattern.compile("/\\*(.*?)\\*/", 32);
    private static final Pattern SINGLELINE_COMMENT_PATTERN = Pattern.compile("//(.*?)<br />", 32);
    private static final Pattern STRING_PATTERN = Pattern.compile("&quot;(.*?)&quot;");

    private JavaHTMLizer() {
    }

    static String htmlize(String javaSource) {
        Object result = "-" + javaSource;
        result = JavaHTMLizer.htmlEscape((String)result);
        result = JavaHTMLizer.formatReservedWords((String)result);
        result = JavaHTMLizer.formatComments((String)result);
        result = JavaHTMLizer.formatStrings((String)result);
        return ((String)result).substring(1);
    }

    static String htmlizeFull(String javaSource) {
        String result = JavaHTMLizer.htmlize(javaSource);
        String start = "<html><body><style>code { font-size: 12px; } code .string { color: blue; } code .comment { font-style: italic; color: green; } code .keyword { font-weight: bold; color: purple; } code .comment .keyword { color: green; font-weight: normal; } code .comment .string { color: green; } </style><code>";
        String end = "</code></body></html>";
        return "<html><body><style>code { font-size: 12px; } code .string { color: blue; } code .comment { font-style: italic; color: green; } code .keyword { font-weight: bold; color: purple; } code .comment .keyword { color: green; font-weight: normal; } code .comment .string { color: green; } </style><code>" + result + "</code></body></html>";
    }

    static String addLineNumbers(String javaSource) {
        StringBuilder sb = new StringBuilder(javaSource);
        sb.insert(0, "<a name=1 href=#1>1</a> ");
        int line = 2;
        int index = sb.indexOf(BR);
        while (index != -1) {
            int offset = index + BR.length();
            String strLine = Integer.toString(line);
            sb.insert(offset, "</a> ");
            sb.insert(offset, strLine);
            sb.insert(offset, '>');
            sb.insert(offset, strLine);
            sb.insert(offset, " href=#");
            sb.insert(offset, strLine);
            sb.insert(offset, "<a name=");
            index = sb.indexOf(BR, index + 1);
            ++line;
        }
        return sb.toString();
    }

    private static List<Pattern> createReservedWordPatterns(List<String> reservedWords) {
        ArrayList<Pattern> result = new ArrayList<Pattern>(reservedWords.size());
        for (String reservedWord : reservedWords) {
            result.add(Pattern.compile("(\\W)(" + reservedWord + ")(\\W)"));
        }
        return result;
    }

    private static Map<Character, String> createEscapeMaps() {
        LinkedHashMap<Character, String> escapeMaps = new LinkedHashMap<Character, String>();
        escapeMaps.put(Character.valueOf(' '), "&nbsp;");
        escapeMaps.put(Character.valueOf('\t'), "&nbsp;&nbsp;&nbsp;&nbsp;");
        escapeMaps.put(Character.valueOf('<'), "&lt;");
        escapeMaps.put(Character.valueOf('>'), "&gt;");
        escapeMaps.put(Character.valueOf('\"'), "&quot;");
        escapeMaps.put(Character.valueOf('&'), "&amp;");
        escapeMaps.put(Character.valueOf('\''), "&#39;");
        escapeMaps.put(Character.valueOf('\n'), BR);
        return escapeMaps;
    }

    private static String escapeChar(char c) {
        return ESCAPE_MAPS.get(Character.valueOf(c));
    }

    private static String htmlEscape(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            String escapedOrNull = JavaHTMLizer.escapeChar(c);
            if (escapedOrNull == null) {
                sb.append(c);
                continue;
            }
            sb.append(escapedOrNull);
        }
        return sb.toString();
    }

    private static String formatReservedWords(String text) {
        String result = text;
        for (Pattern reservedWordPattern : RESERVED_WORDS_PATTERNS) {
            result = reservedWordPattern.matcher(result).replaceAll("$1<span class=\"keyword\">$2</span>$3");
        }
        return result;
    }

    private static String formatComments(String text) {
        String result = text;
        result = MULTILINE_COMMENT_PATTERN.matcher(result).replaceAll("<span class=\"comment\">/*$1*/</span>");
        result = SINGLELINE_COMMENT_PATTERN.matcher(result).replaceAll("<span class=\"comment\">//$1</span><br />");
        return result;
    }

    private static String formatStrings(String text) {
        return STRING_PATTERN.matcher(text).replaceAll("<span class=\"string\">&quot;$1&quot;</span>");
    }
}

