/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.maven;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.maven.plugin.logging.Log;

public class ByteBuddyLogHandler
extends Handler {
    private final Log log;
    private final Logger logger;
    private final boolean useParentHandlers;

    protected ByteBuddyLogHandler(Log log, Logger logger, boolean useParentHandlers) {
        this.log = log;
        this.logger = logger;
        this.useParentHandlers = useParentHandlers;
        this.setFormatter(new SimpleFormatter());
    }

    public static ByteBuddyLogHandler initialize(Log log) {
        Logger logger = Logger.getLogger("net.bytebuddy");
        ByteBuddyLogHandler handler = new ByteBuddyLogHandler(log, logger, logger.getUseParentHandlers());
        try {
            logger.setUseParentHandlers(false);
            logger.addHandler(handler);
        }
        catch (SecurityException exception) {
            log.warn((CharSequence)"Cannot configure Byte Buddy logging", (Throwable)exception);
        }
        return handler;
    }

    public void reset() {
        try {
            this.logger.setUseParentHandlers(this.useParentHandlers);
            this.logger.removeHandler(this);
        }
        catch (SecurityException exception) {
            this.log.warn((CharSequence)"Cannot configure Byte Buddy logging", (Throwable)exception);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)this.getFormatter().format(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ByteBuddyLogHandler that = (ByteBuddyLogHandler)object;
        return this.useParentHandlers == that.useParentHandlers && this.logger.equals(that.logger) && this.log.equals(that.log);
    }

    public int hashCode() {
        int result = this.log.hashCode();
        result = 31 * result + this.logger.hashCode();
        result = 31 * result + (this.useParentHandlers ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ByteBuddyLogHandler{log=" + this.log + " ,logger=" + this.logger + " ,useParentHandlers=" + this.useParentHandlers + '}';
    }
}

