/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.maven;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.maven.ByteBuddyLogHandler;
import net.bytebuddy.build.maven.ClassLoaderResolver;
import net.bytebuddy.build.maven.Initialization;
import net.bytebuddy.build.maven.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.pool.TypePool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class ByteBuddyMojo
extends AbstractMojo {
    private static final String CLASS_FILE_EXTENSION = ".class";
    @Parameter(defaultValue="${project.groupId}", required=true, readonly=true)
    protected String groupId;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String artifactId;
    @Parameter(defaultValue="${project.version}", required=true, readonly=true)
    protected String version;
    @Parameter
    protected List<Transformation> transformations;
    @Parameter
    protected Initialization initialization;
    @Parameter
    protected String suffix;
    @Parameter(defaultValue="true", required=true)
    protected boolean failOnLiveInitializer;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", required=true, readonly=true)
    protected List<RemoteRepository> remoteRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.transformations == null || this.transformations.isEmpty()) {
            this.getLog().warn((CharSequence)"No transformations are specified. Skipping plugin application.");
            return;
        }
        ByteBuddyLogHandler byteBuddyLogHandler = ByteBuddyLogHandler.initialize(this.getLog());
        try {
            this.processOutputDirectory(new File(this.getOutputDirectory()), this.getClassPathElements());
        }
        catch (IOException exception) {
            throw new MojoFailureException("Error during writing process", (Throwable)exception);
        }
        finally {
            byteBuddyLogHandler.reset();
        }
    }

    protected abstract String getOutputDirectory();

    protected abstract List<String> getClassPathElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Applies Maven exception wrapper")
    private void processOutputDirectory(File root, List<? extends String> classPath) throws MojoExecutionException, MojoFailureException, IOException {
        if (!root.isDirectory()) {
            throw new MojoExecutionException("Target location does not exist or is no directory: " + root);
        }
        ClassLoaderResolver classLoaderResolver = new ClassLoaderResolver(this.getLog(), this.repositorySystem, this.repositorySystemSession, this.remoteRepositories);
        try {
            ArrayList<Plugin> plugins = new ArrayList<Plugin>(this.transformations.size());
            for (Transformation transformation : this.transformations) {
                String plugin = transformation.getPlugin();
                try {
                    plugins.add((Plugin)Class.forName(plugin, false, classLoaderResolver.resolve(transformation.asCoordinate(this.groupId, this.artifactId, this.version))).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    this.getLog().info((CharSequence)("Created plugin: " + plugin));
                }
                catch (Exception exception) {
                    throw new MojoExecutionException("Cannot create plugin: " + transformation.getRawPlugin(), exception);
                }
            }
            EntryPoint entryPoint = (this.initialization == null ? Initialization.makeDefault() : this.initialization).getEntryPoint(classLoaderResolver, this.groupId, this.artifactId, this.version);
            this.getLog().info((CharSequence)("Resolved entry point: " + entryPoint));
            this.transform(root, entryPoint, classPath, plugins);
        }
        finally {
            classLoaderResolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(File root, EntryPoint entryPoint, List<? extends String> classPath, List<Plugin> plugins) throws MojoExecutionException, MojoFailureException, IOException {
        ArrayList<Object> classFileLocators = new ArrayList<Object>(classPath.size() + 1);
        classFileLocators.add(new ClassFileLocator.ForFolder(root));
        for (String string : classPath) {
            File artifact = new File(string);
            classFileLocators.add(artifact.isFile() ? ClassFileLocator.ForJarFile.of((File)artifact) : new ClassFileLocator.ForFolder(artifact));
        }
        ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);
        try {
            ByteBuddy byteBuddy;
            TypePool.Default.WithLazyResolution withLazyResolution = new TypePool.Default.WithLazyResolution((TypePool.CacheProvider)new TypePool.CacheProvider.Simple(), (ClassFileLocator)classFileLocator, TypePool.Default.ReaderMode.FAST, TypePool.ClassLoading.ofBootPath());
            this.getLog().info((CharSequence)("Processing class files located in in: " + root));
            try {
                byteBuddy = entryPoint.getByteBuddy();
            }
            catch (Throwable throwable) {
                throw new MojoExecutionException("Cannot create Byte Buddy instance", throwable);
            }
            this.processDirectory(root, root, byteBuddy, entryPoint, (MethodNameTransformer)(this.suffix == null || this.suffix.isEmpty() ? MethodNameTransformer.Suffixing.withRandomSuffix() : new MethodNameTransformer.Suffixing(this.suffix)), (ClassFileLocator)classFileLocator, (TypePool)withLazyResolution, plugins);
        }
        finally {
            classFileLocator.close();
        }
    }

    private void processDirectory(File root, File folder, ByteBuddy byteBuddy, EntryPoint entryPoint, MethodNameTransformer methodNameTransformer, ClassFileLocator classFileLocator, TypePool typePool, List<Plugin> plugins) throws MojoExecutionException, MojoFailureException {
        File[] file = folder.listFiles();
        if (file != null) {
            for (File aFile : file) {
                if (aFile.isDirectory()) {
                    this.processDirectory(root, aFile, byteBuddy, entryPoint, methodNameTransformer, classFileLocator, typePool, plugins);
                    continue;
                }
                if (aFile.isFile() && aFile.getName().endsWith(CLASS_FILE_EXTENSION)) {
                    this.processClassFile(root, root.toURI().relativize(aFile.toURI()).toString(), byteBuddy, entryPoint, methodNameTransformer, classFileLocator, typePool, plugins);
                    continue;
                }
                this.getLog().debug((CharSequence)("Skipping ignored file: " + aFile));
            }
        }
    }

    private void processClassFile(File root, String file, ByteBuddy byteBuddy, EntryPoint entryPoint, MethodNameTransformer methodNameTransformer, ClassFileLocator classFileLocator, TypePool typePool, List<Plugin> plugins) throws MojoExecutionException, MojoFailureException {
        DynamicType.Builder builder;
        String typeName = file.replace(File.separatorChar, '.').substring(0, file.length() - CLASS_FILE_EXTENSION.length());
        this.getLog().debug((CharSequence)("Processing class file: " + typeName));
        TypeDescription typeDescription = typePool.describe(typeName).resolve();
        try {
            builder = entryPoint.transform(typeDescription, byteBuddy, classFileLocator, methodNameTransformer);
        }
        catch (Throwable throwable) {
            throw new MojoExecutionException("Cannot transform type: " + typeName, throwable);
        }
        boolean transformed = false;
        for (Plugin plugin : plugins) {
            try {
                if (!plugin.matches((Object)typeDescription)) continue;
                builder = plugin.apply(builder, typeDescription);
                transformed = true;
            }
            catch (Throwable throwable) {
                throw new MojoExecutionException("Cannot apply " + plugin + " on " + typeName, throwable);
            }
        }
        if (transformed) {
            this.getLog().info((CharSequence)("Transformed type: " + typeName));
            DynamicType.Unloaded dynamicType = builder.make();
            for (Map.Entry entry : dynamicType.getLoadedTypeInitializers().entrySet()) {
                if (!this.failOnLiveInitializer || !((LoadedTypeInitializer)entry.getValue()).isAlive()) continue;
                throw new MojoExecutionException("Cannot apply live initializer for " + entry.getKey());
            }
            try {
                dynamicType.saveIn(root);
            }
            catch (IOException iOException) {
                throw new MojoFailureException("Cannot save " + typeName + " in " + root, (Throwable)iOException);
            }
        } else {
            this.getLog().debug((CharSequence)("Skipping non-transformed type: " + typeName));
        }
    }

    @Mojo(name="transform-test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
    public static class ForTestTypes
    extends ByteBuddyMojo {
        @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
        protected String testOutputDirectory;
        @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
        protected List<String> testClasspathElements;

        @Override
        protected String getOutputDirectory() {
            return this.testOutputDirectory;
        }

        @Override
        protected List<String> getClassPathElements() {
            return this.testClasspathElements;
        }
    }

    @Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
    public static class ForProductionTypes
    extends ByteBuddyMojo {
        @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
        protected String outputDirectory;
        @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
        protected List<String> compileClasspathElements;

        @Override
        protected String getOutputDirectory() {
            return this.outputDirectory;
        }

        @Override
        protected List<String> getClassPathElements() {
            return this.compileClasspathElements;
        }
    }
}

