/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.utility.PropertyDispatcher;

public interface AnnotationValue<T, S> {
    public static final AnnotationValue<?, ?> UNDEFINED = null;

    public T resolve();

    public <S> S resolve(Class<? extends S> var1);

    public Loaded<S> load(ClassLoader var1) throws ClassNotFoundException;

    public static class ForComplexArray<U, V>
    extends AbstractBase<U[], V[]> {
        private final Class<?> unloadedComponentType;
        private final TypeDescription componentType;
        private final List<? extends AnnotationValue<?, ?>> annotationValues;

        protected ForComplexArray(Class<?> unloadedComponentType, TypeDescription componentType, List<? extends AnnotationValue<?, ?>> annotationValues) {
            this.unloadedComponentType = unloadedComponentType;
            this.componentType = componentType;
            this.annotationValues = annotationValues;
        }

        public static <W extends Enum<W>> AnnotationValue<EnumerationDescription[], W[]> of(TypeDescription enumerationType, EnumerationDescription[] enumerationDescription) {
            ArrayList values = new ArrayList(enumerationDescription.length);
            for (EnumerationDescription value : enumerationDescription) {
                if (!value.getEnumerationType().equals(enumerationType)) {
                    throw new IllegalArgumentException(value + " is not of " + enumerationType);
                }
                values.add(ForEnumeration.of(value));
            }
            return new ForComplexArray(EnumerationDescription.class, enumerationType, values);
        }

        public static <W extends Annotation> AnnotationValue<AnnotationDescription[], W[]> of(TypeDescription annotationType, AnnotationDescription[] annotationDescription) {
            ArrayList values = new ArrayList(annotationDescription.length);
            for (AnnotationDescription value : annotationDescription) {
                if (!value.getAnnotationType().equals(annotationType)) {
                    throw new IllegalArgumentException(value + " is not of " + annotationType);
                }
                values.add(new ForAnnotation(value));
            }
            return new ForComplexArray(AnnotationDescription.class, annotationType, values);
        }

        public static AnnotationValue<TypeDescription[], Class<?>[]> of(TypeDescription[] typeDescription) {
            ArrayList values = new ArrayList(typeDescription.length);
            for (TypeDescription value : typeDescription) {
                values.add(ForType.of(value));
            }
            return new ForComplexArray(TypeDescription.class, TypeDescription.CLASS, values);
        }

        @Override
        public U[] resolve() {
            Object[] value = (Object[])Array.newInstance(this.unloadedComponentType, this.annotationValues.size());
            int index = 0;
            for (AnnotationValue<?, ?> annotationValue : this.annotationValues) {
                Array.set(value, index++, annotationValue.resolve());
            }
            return value;
        }

        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<V[]> load(ClassLoader classLoader) throws ClassNotFoundException {
            ArrayList loadedValues = new ArrayList(this.annotationValues.size());
            for (AnnotationValue<?, ?> value : this.annotationValues) {
                loadedValues.add(value.load(classLoader));
            }
            return new Loaded(Class.forName(this.componentType.getName(), false, classLoader), loadedValues);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForComplexArray that = (ForComplexArray)other;
            return this.annotationValues.equals(that.annotationValues) && this.componentType.equals(that.componentType) && this.unloadedComponentType.equals(that.unloadedComponentType);
        }

        public int hashCode() {
            int result = this.unloadedComponentType.hashCode();
            result = 31 * result + this.componentType.hashCode();
            result = 31 * result + this.annotationValues.hashCode();
            return result;
        }

        public String toString() {
            return "AnnotationValue.ForComplexArray{unloadedComponentType=" + this.unloadedComponentType + ", componentType=" + this.componentType + ", annotationValues=" + this.annotationValues + '}';
        }

        protected static class Loaded<W>
        extends Loaded.AbstractBase<W[]> {
            private final Class<W> componentType;
            private final List<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>> values;

            protected Loaded(Class<W> componentType, List<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>> values) {
                this.componentType = componentType;
                this.values = values;
            }

            @Override
            public Loaded.State getState() {
                for (net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> value : this.values) {
                    if (value.getState().isResolved()) continue;
                    return Loaded.State.NON_RESOLVED;
                }
                return Loaded.State.RESOLVED;
            }

            @Override
            public W[] resolve() {
                Object[] array = (Object[])Array.newInstance(this.componentType, this.values.size());
                int index = 0;
                for (net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> annotationValue : this.values) {
                    Array.set(array, index++, annotationValue.resolve());
                }
                return array;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                if (!loadedOther.getState().isResolved()) {
                    return false;
                }
                Object otherValue = loadedOther.resolve();
                if (!(otherValue instanceof Object[])) {
                    return false;
                }
                Object[] otherArrayValue = (Object[])otherValue;
                if (this.values.size() != otherArrayValue.length) {
                    return false;
                }
                Iterator<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>> iterator = this.values.iterator();
                for (Object value : otherArrayValue) {
                    net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> self = iterator.next();
                    if (self.getState().isResolved() && self.resolve().equals(value)) continue;
                    return false;
                }
                return true;
            }

            public int hashCode() {
                int result = 1;
                for (net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> value : this.values) {
                    result = 31 * result + value.hashCode();
                }
                return result;
            }

            public String toString() {
                char close;
                char open;
                if (this.componentType == Class.class) {
                    open = PropertyDispatcher.TypeRenderer.CURRENT.getOpen();
                    close = PropertyDispatcher.TypeRenderer.CURRENT.getClose();
                } else {
                    open = '[';
                    close = ']';
                }
                StringBuilder stringBuilder = new StringBuilder().append(open);
                for (net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> value : this.values) {
                    stringBuilder.append(value.toString());
                }
                return stringBuilder.append(close).toString();
            }
        }
    }

    public static class ForType<U extends Class<U>>
    extends AbstractBase<TypeDescription, U> {
        private static final boolean NO_INITIALIZATION = false;
        private final TypeDescription typeDescription;

        public ForType(TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
        }

        public static <V extends Class<V>> AnnotationValue<TypeDescription, V> of(TypeDescription typeDescription) {
            return new ForType(typeDescription);
        }

        @Override
        public TypeDescription resolve() {
            return this.typeDescription;
        }

        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(ClassLoader classLoader) throws ClassNotFoundException {
            return new Loaded(Class.forName(this.typeDescription.getName(), false, classLoader));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForType forType = (ForType)other;
            return this.typeDescription.equals(forType.typeDescription);
        }

        public int hashCode() {
            return this.typeDescription.hashCode();
        }

        public String toString() {
            return "AnnotationValue.ForType{typeDescription=" + this.typeDescription + '}';
        }

        protected static class Loaded<U extends Class<U>>
        extends Loaded.AbstractBase<U> {
            private final U type;

            public Loaded(U type) {
                this.type = type;
            }

            @Override
            public Loaded.State getState() {
                return Loaded.State.RESOLVED;
            }

            @Override
            public U resolve() {
                return this.type;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return loadedOther.getState().isResolved() && this.type.equals(loadedOther.resolve());
            }

            public int hashCode() {
                return this.type.hashCode();
            }

            public String toString() {
                return PropertyDispatcher.TYPE_LOADED.toString(this.type);
            }
        }
    }

    public static class ForEnumeration<U extends Enum<U>>
    extends AbstractBase<EnumerationDescription, U> {
        private final EnumerationDescription enumerationDescription;

        public ForEnumeration(EnumerationDescription enumerationDescription) {
            this.enumerationDescription = enumerationDescription;
        }

        public static <V extends Enum<V>> AnnotationValue<EnumerationDescription, V> of(EnumerationDescription value) {
            return new ForEnumeration(value);
        }

        @Override
        public EnumerationDescription resolve() {
            return this.enumerationDescription;
        }

        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(ClassLoader classLoader) throws ClassNotFoundException {
            Class<?> enumerationType = Class.forName(this.enumerationDescription.getEnumerationType().getName(), false, classLoader);
            return new Loaded(this.enumerationDescription.load(enumerationType));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForEnumeration that = (ForEnumeration)other;
            return this.enumerationDescription.equals(that.enumerationDescription);
        }

        public int hashCode() {
            return this.enumerationDescription.hashCode();
        }

        public String toString() {
            return "AnnotationValue.ForEnumeration{enumerationDescription=" + this.enumerationDescription + '}';
        }

        public static class IncompatibleRuntimeType
        extends Loaded.AbstractBase<Enum<?>> {
            private final Class<?> type;

            public IncompatibleRuntimeType(Class<?> type) {
                this.type = type;
            }

            @Override
            public Loaded.State getState() {
                return Loaded.State.NON_RESOLVED;
            }

            @Override
            public Enum<?> resolve() {
                throw new IncompatibleClassChangeError("Not an enumeration type: " + this.type.toString());
            }
        }

        public static class UnknownRuntimeEnumeration
        extends Loaded.AbstractBase<Enum<?>> {
            private final Class<? extends Enum<?>> enumType;
            private final String value;

            public UnknownRuntimeEnumeration(Class<? extends Enum<?>> enumType, String value) {
                this.enumType = enumType;
                this.value = value;
            }

            @Override
            public Loaded.State getState() {
                return Loaded.State.NON_RESOLVED;
            }

            @Override
            public Enum<?> resolve() {
                throw new EnumConstantNotPresentException(this.enumType, this.value);
            }
        }

        public static class Loaded<V extends Enum<V>>
        extends Loaded.AbstractBase<V> {
            private final V enumeration;

            public Loaded(V enumeration) {
                this.enumeration = enumeration;
            }

            @Override
            public Loaded.State getState() {
                return Loaded.State.RESOLVED;
            }

            @Override
            public V resolve() {
                return this.enumeration;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return loadedOther.getState().isResolved() && ((Enum)this.enumeration).equals(loadedOther.resolve());
            }

            public int hashCode() {
                return ((Enum)this.enumeration).hashCode();
            }

            public String toString() {
                return ((Enum)this.enumeration).toString();
            }
        }
    }

    public static class ForAnnotation<U extends Annotation>
    extends AbstractBase<AnnotationDescription, U> {
        private final AnnotationDescription annotationDescription;

        public ForAnnotation(AnnotationDescription annotationDescription) {
            this.annotationDescription = annotationDescription;
        }

        public static <V extends Annotation> AnnotationValue<AnnotationDescription, V> of(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
            return new ForAnnotation(new AnnotationDescription.Latent(annotationType, annotationValues));
        }

        @Override
        public AnnotationDescription resolve() {
            return this.annotationDescription;
        }

        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(ClassLoader classLoader) throws ClassNotFoundException {
            Class<?> annotationType = Class.forName(this.annotationDescription.getAnnotationType().getName(), false, classLoader);
            return new Loaded(this.annotationDescription.prepare(annotationType).load());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForAnnotation that = (ForAnnotation)other;
            return this.annotationDescription.equals(that.annotationDescription);
        }

        public int hashCode() {
            return this.annotationDescription.hashCode();
        }

        public String toString() {
            return "AnnotationValue.ForAnnotation{annotationDescription=" + this.annotationDescription + '}';
        }

        public static class IncompatibleRuntimeType
        extends Loaded.AbstractBase<Annotation> {
            private final Class<?> incompatibleType;

            public IncompatibleRuntimeType(Class<?> incompatibleType) {
                this.incompatibleType = incompatibleType;
            }

            @Override
            public Loaded.State getState() {
                return Loaded.State.NON_RESOLVED;
            }

            @Override
            public Annotation resolve() {
                throw new IncompatibleClassChangeError("Not an annotation type: " + this.incompatibleType.toString());
            }
        }

        public static class Loaded<V extends Annotation>
        extends Loaded.AbstractBase<V> {
            private final V annotation;

            public Loaded(V annotation) {
                this.annotation = annotation;
            }

            @Override
            public Loaded.State getState() {
                return Loaded.State.RESOLVED;
            }

            @Override
            public V resolve() {
                return this.annotation;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return loadedOther.getState().isResolved() && this.annotation.equals(loadedOther.resolve());
            }

            public int hashCode() {
                return this.annotation.hashCode();
            }

            public String toString() {
                return this.annotation.toString();
            }
        }
    }

    public static class ForConstant<U>
    extends AbstractBase<U, U> {
        private final U value;
        private final PropertyDispatcher propertyDispatcher;

        public ForConstant(U value) {
            this.value = value;
            this.propertyDispatcher = PropertyDispatcher.of(value.getClass());
        }

        @Override
        public U resolve() {
            return this.value;
        }

        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(ClassLoader classLoader) {
            return new Loaded<U>(this.value, this.propertyDispatcher);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.propertyDispatcher.equals(this.value, ((ForConstant)other).value);
        }

        public int hashCode() {
            return this.propertyDispatcher.hashCode(this.value);
        }

        public String toString() {
            return "AnnotationValue.ForConstant{value=" + this.value + ", propertyDispatcher=" + (Object)((Object)this.propertyDispatcher) + '}';
        }

        public static class Loaded<V>
        extends Loaded.AbstractBase<V> {
            private final V value;
            private final PropertyDispatcher propertyDispatcher;

            public Loaded(V value, PropertyDispatcher propertyDispatcher) {
                this.value = value;
                this.propertyDispatcher = propertyDispatcher;
            }

            @Override
            public Loaded.State getState() {
                return Loaded.State.RESOLVED;
            }

            @Override
            public V resolve() {
                return this.propertyDispatcher.conditionalClone(this.value);
            }

            public int hashCode() {
                return this.propertyDispatcher.hashCode(this.value);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return loadedOther.getState().isResolved() && this.propertyDispatcher.equals(this.value, loadedOther.resolve());
            }

            public String toString() {
                return this.propertyDispatcher.toString(this.value);
            }
        }
    }

    public static abstract class AbstractBase<U, V>
    implements AnnotationValue<U, V> {
        @Override
        public <S> S resolve(Class<? extends S> type) {
            return type.cast(this.resolve());
        }
    }

    public static interface Loaded<U> {
        public State getState();

        public U resolve();

        public <V> V resolve(Class<? extends V> var1);

        public static abstract class AbstractBase<W>
        implements Loaded<W> {
            @Override
            public <S> S resolve(Class<? extends S> type) {
                return type.cast(this.resolve());
            }
        }

        public static enum State {
            NON_DEFINED,
            NON_RESOLVED,
            RESOLVED;


            public boolean isDefined() {
                return this != NON_DEFINED;
            }

            public boolean isResolved() {
                return this == RESOLVED;
            }

            public String toString() {
                return "AnnotationValue.Loaded.State." + this.name();
            }
        }
    }
}

