/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class CompoundList<T>
extends AbstractList<T> {
    private final List<? extends T> left;
    private final List<? extends T> right;

    protected CompoundList(List<? extends T> left, List<? extends T> right) {
        this.left = left;
        this.right = right;
    }

    public static <S> List<S> of(S left, List<? extends S> right) {
        return CompoundList.of(Collections.singletonList(left), right);
    }

    public static <S> List<S> of(List<? extends S> left, S right) {
        return CompoundList.of(left, Collections.singletonList(right));
    }

    public static <S> List<S> of(List<? extends S> left, List<? extends S> right) {
        return new CompoundList<S>(left, right);
    }

    @Override
    public T get(int index) {
        int leftSize = this.left.size();
        return leftSize - index > 0 ? this.left.get(index) : this.right.get(index - leftSize);
    }

    @Override
    public int size() {
        return this.left.size() + this.right.size();
    }
}

