/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.corda.client.jackson.JacksonSupport;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.StateRef;
import net.corda.core.crypto.Base58;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.MerkleTree;
import net.corda.core.crypto.SecureHash;
import net.corda.core.crypto.TransactionSignature;
import net.corda.core.identity.AnonymousParty;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.services.IdentityService;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.transactions.CoreTransaction;
import net.corda.core.transactions.NotaryChangeWireTransaction;
import net.corda.core.transactions.WireTransaction;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.EncodingUtils;
import net.corda.core.utilities.OpaqueBytes;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0019\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J$\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J$\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00060"}, d2={"Lnet/corda/client/jackson/JacksonSupport;", "", "()V", "cordaModule", "Lcom/fasterxml/jackson/databind/Module;", "getCordaModule", "()Lcom/fasterxml/jackson/databind/Module;", "cordaModule$delegate", "Lkotlin/Lazy;", "configureMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapper", "createDefaultMapper", "rpc", "Lnet/corda/core/messaging/CordaRPCOps;", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "fuzzyIdentityMatch", "", "createInMemoryMapper", "identityService", "Lnet/corda/core/node/services/IdentityService;", "createNonRpcMapper", "AmountDeserializer", "AmountSerializer", "AnonymousPartyDeserializer", "AnonymousPartySerializer", "CompositeKeyDeserializer", "CompositeKeySerializer", "CordaX500NameDeserializer", "CordaX500NameSerializer", "IdentityObjectMapper", "NoPartyObjectMapper", "NodeInfoDeserializer", "NodeInfoSerializer", "OpaqueBytesDeserializer", "OpaqueBytesSerializer", "PartyDeserializer", "PartyObjectMapper", "PartySerializer", "PublicKeyDeserializer", "PublicKeySerializer", "RpcObjectMapper", "SecureHashDeserializer", "SecureHashSerializer", "SignedTransactionMixin", "ToStringSerializer", "WireTransactionMixin", "jackson_main"})
public final class JacksonSupport {
    @NotNull
    private static final Lazy cordaModule$delegate;
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final JacksonSupport INSTANCE;

    @NotNull
    public final Module getCordaModule() {
        Lazy lazy = cordaModule$delegate;
        JacksonSupport jacksonSupport = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Module)lazy.getValue();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createDefaultMapper(@NotNull CordaRPCOps rpc, @NotNull JsonFactory factory, boolean fuzzyIdentityMatch) {
        Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        return INSTANCE.configureMapper(new RpcObjectMapper(rpc, factory, fuzzyIdentityMatch));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ObjectMapper createDefaultMapper$default(CordaRPCOps cordaRPCOps, JsonFactory jsonFactory, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            jsonFactory = new JsonFactory();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return JacksonSupport.createDefaultMapper(cordaRPCOps, jsonFactory, bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createDefaultMapper(@NotNull CordaRPCOps rpc, @NotNull JsonFactory factory) {
        return JacksonSupport.createDefaultMapper$default(rpc, factory, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createDefaultMapper(@NotNull CordaRPCOps rpc) {
        return JacksonSupport.createDefaultMapper$default(rpc, null, false, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createNonRpcMapper(@NotNull JsonFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        return INSTANCE.configureMapper(new NoPartyObjectMapper(factory));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ObjectMapper createNonRpcMapper$default(JsonFactory jsonFactory, int n, Object object) {
        if ((n & 1) != 0) {
            jsonFactory = new JsonFactory();
        }
        return JacksonSupport.createNonRpcMapper(jsonFactory);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createNonRpcMapper() {
        return JacksonSupport.createNonRpcMapper$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createInMemoryMapper(@NotNull IdentityService identityService, @NotNull JsonFactory factory, boolean fuzzyIdentityMatch) {
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        return INSTANCE.configureMapper(new IdentityObjectMapper(identityService, factory, fuzzyIdentityMatch));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ObjectMapper createInMemoryMapper$default(IdentityService identityService, JsonFactory jsonFactory, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            jsonFactory = new JsonFactory();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return JacksonSupport.createInMemoryMapper(identityService, jsonFactory, bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createInMemoryMapper(@NotNull IdentityService identityService, @NotNull JsonFactory factory) {
        return JacksonSupport.createInMemoryMapper$default(identityService, factory, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ObjectMapper createInMemoryMapper(@NotNull IdentityService identityService) {
        return JacksonSupport.createInMemoryMapper$default(identityService, null, false, 6, null);
    }

    private final ObjectMapper configureMapper(ObjectMapper mapper) {
        ObjectMapper objectMapper;
        ObjectMapper $receiver = objectMapper = mapper;
        $receiver.enable(SerializationFeature.INDENT_OUTPUT);
        $receiver.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        $receiver.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        $receiver.registerModule((Module)new JavaTimeModule());
        $receiver.registerModule(INSTANCE.getCordaModule());
        $receiver.registerModule((Module)new KotlinModule(0, 1, null));
        return objectMapper;
    }

    private JacksonSupport() {
        INSTANCE = this;
        cordaModule$delegate = LazyKt.lazy((Function0)cordaModule.2.INSTANCE);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JacksonSupport.class), "cordaModule", "getCordaModule()Lcom/fasterxml/jackson/databind/Module;"))};
        new JacksonSupport();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH&J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lnet/corda/client/jackson/JacksonSupport$PartyObjectMapper;", "", "partiesFromName", "", "Lnet/corda/core/identity/Party;", "query", "", "partyFromKey", "owningKey", "Ljava/security/PublicKey;", "wellKnownPartyFromX500Name", "name", "Lnet/corda/core/identity/CordaX500Name;", "jackson_main"})
    public static interface PartyObjectMapper {
        @Nullable
        public Party wellKnownPartyFromX500Name(@NotNull CordaX500Name var1);

        @Nullable
        public Party partyFromKey(@NotNull PublicKey var1);

        @NotNull
        public Set<Party> partiesFromName(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lnet/corda/client/jackson/JacksonSupport$RpcObjectMapper;", "Lnet/corda/client/jackson/JacksonSupport$PartyObjectMapper;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "rpc", "Lnet/corda/core/messaging/CordaRPCOps;", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "fuzzyIdentityMatch", "", "(Lnet/corda/core/messaging/CordaRPCOps;Lcom/fasterxml/jackson/core/JsonFactory;Z)V", "getFuzzyIdentityMatch", "()Z", "getRpc", "()Lnet/corda/core/messaging/CordaRPCOps;", "partiesFromName", "", "Lnet/corda/core/identity/Party;", "query", "", "partyFromKey", "owningKey", "Ljava/security/PublicKey;", "wellKnownPartyFromX500Name", "name", "Lnet/corda/core/identity/CordaX500Name;", "jackson_main"})
    public static final class RpcObjectMapper
    extends ObjectMapper
    implements PartyObjectMapper {
        @NotNull
        private final CordaRPCOps rpc;
        private final boolean fuzzyIdentityMatch;

        @Override
        @Nullable
        public Party wellKnownPartyFromX500Name(@NotNull CordaX500Name name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.rpc.wellKnownPartyFromX500Name(name);
        }

        @Override
        @Nullable
        public Party partyFromKey(@NotNull PublicKey owningKey) {
            Intrinsics.checkParameterIsNotNull((Object)owningKey, (String)"owningKey");
            return this.rpc.partyFromKey(owningKey);
        }

        @Override
        @NotNull
        public Set<Party> partiesFromName(@NotNull String query) {
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            return this.rpc.partiesFromName(query, this.fuzzyIdentityMatch);
        }

        @NotNull
        public final CordaRPCOps getRpc() {
            return this.rpc;
        }

        public final boolean getFuzzyIdentityMatch() {
            return this.fuzzyIdentityMatch;
        }

        public RpcObjectMapper(@NotNull CordaRPCOps rpc, @NotNull JsonFactory factory, boolean fuzzyIdentityMatch) {
            Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
            Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
            super(factory);
            this.rpc = rpc;
            this.fuzzyIdentityMatch = fuzzyIdentityMatch;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lnet/corda/client/jackson/JacksonSupport$IdentityObjectMapper;", "Lnet/corda/client/jackson/JacksonSupport$PartyObjectMapper;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "identityService", "Lnet/corda/core/node/services/IdentityService;", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "fuzzyIdentityMatch", "", "(Lnet/corda/core/node/services/IdentityService;Lcom/fasterxml/jackson/core/JsonFactory;Z)V", "getFuzzyIdentityMatch", "()Z", "getIdentityService", "()Lnet/corda/core/node/services/IdentityService;", "partiesFromName", "", "Lnet/corda/core/identity/Party;", "query", "", "partyFromKey", "owningKey", "Ljava/security/PublicKey;", "wellKnownPartyFromX500Name", "name", "Lnet/corda/core/identity/CordaX500Name;", "jackson_main"})
    public static final class IdentityObjectMapper
    extends ObjectMapper
    implements PartyObjectMapper {
        @NotNull
        private final IdentityService identityService;
        private final boolean fuzzyIdentityMatch;

        @Override
        @Nullable
        public Party wellKnownPartyFromX500Name(@NotNull CordaX500Name name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.identityService.wellKnownPartyFromX500Name(name);
        }

        @Override
        @Nullable
        public Party partyFromKey(@NotNull PublicKey owningKey) {
            Intrinsics.checkParameterIsNotNull((Object)owningKey, (String)"owningKey");
            return this.identityService.partyFromKey(owningKey);
        }

        @Override
        @NotNull
        public Set<Party> partiesFromName(@NotNull String query) {
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            return this.identityService.partiesFromName(query, this.fuzzyIdentityMatch);
        }

        @NotNull
        public final IdentityService getIdentityService() {
            return this.identityService;
        }

        public final boolean getFuzzyIdentityMatch() {
            return this.fuzzyIdentityMatch;
        }

        public IdentityObjectMapper(@NotNull IdentityService identityService, @NotNull JsonFactory factory, boolean fuzzyIdentityMatch) {
            Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
            Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
            super(factory);
            this.identityService = identityService;
            this.fuzzyIdentityMatch = fuzzyIdentityMatch;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/corda/client/jackson/JacksonSupport$NoPartyObjectMapper;", "Lnet/corda/client/jackson/JacksonSupport$PartyObjectMapper;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "(Lcom/fasterxml/jackson/core/JsonFactory;)V", "partiesFromName", "", "query", "", "partyFromKey", "Lnet/corda/core/identity/Party;", "owningKey", "Ljava/security/PublicKey;", "wellKnownPartyFromX500Name", "name", "Lnet/corda/core/identity/CordaX500Name;", "jackson_main"})
    public static final class NoPartyObjectMapper
    extends ObjectMapper
    implements PartyObjectMapper {
        @Override
        @Nullable
        public Party wellKnownPartyFromX500Name(@NotNull CordaX500Name name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            throw (Throwable)new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Party partyFromKey(@NotNull PublicKey owningKey) {
            Intrinsics.checkParameterIsNotNull((Object)owningKey, (String)"owningKey");
            throw (Throwable)new UnsupportedOperationException();
        }

        @NotNull
        public Void partiesFromName(@NotNull String query) {
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            throw (Throwable)new UnsupportedOperationException();
        }

        public NoPartyObjectMapper(@NotNull JsonFactory factory) {
            Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
            super(factory);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$ToStringSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "", "()V", "serialize", "", "obj", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class ToStringSerializer
    extends JsonSerializer<Object> {
        public static final ToStringSerializer INSTANCE;

        public void serialize(@NotNull Object obj, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeString(obj.toString());
        }

        private ToStringSerializer() {
            INSTANCE = this;
        }

        static {
            new ToStringSerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$AnonymousPartySerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/identity/AnonymousParty;", "()V", "serialize", "", "obj", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class AnonymousPartySerializer
    extends JsonSerializer<AnonymousParty> {
        public static final AnonymousPartySerializer INSTANCE;

        public void serialize(@NotNull AnonymousParty obj, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeString(EncodingUtils.toBase58String((PublicKey)obj.getOwningKey()));
        }

        private AnonymousPartySerializer() {
            INSTANCE = this;
        }

        static {
            new AnonymousPartySerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$AnonymousPartyDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/core/identity/AnonymousParty;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class AnonymousPartyDeserializer
    extends JsonDeserializer<AnonymousParty> {
        public static final AnonymousPartyDeserializer INSTANCE;

        @NotNull
        public AnonymousParty deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Intrinsics.areEqual((Object)parser.getCurrentToken(), (Object)JsonToken.FIELD_NAME)) {
                parser.nextToken();
            }
            String string = parser.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
            PublicKey key = EncodingUtils.parsePublicKeyBase58((String)string);
            return new AnonymousParty(key);
        }

        private AnonymousPartyDeserializer() {
            INSTANCE = this;
        }

        static {
            new AnonymousPartyDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$PartySerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/identity/Party;", "()V", "serialize", "", "obj", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class PartySerializer
    extends JsonSerializer<Party> {
        public static final PartySerializer INSTANCE;

        public void serialize(@NotNull Party obj, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeString(obj.getName().toString());
        }

        private PartySerializer() {
            INSTANCE = this;
        }

        static {
            new PartySerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$PartyDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/core/identity/Party;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class PartyDeserializer
    extends JsonDeserializer<Party> {
        public static final PartyDeserializer INSTANCE;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Party deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            Party party;
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Intrinsics.areEqual((Object)parser.getCurrentToken(), (Object)JsonToken.FIELD_NAME)) {
                parser.nextToken();
            }
            ObjectCodec objectCodec = parser.getCodec();
            if (objectCodec == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.client.jackson.JacksonSupport.PartyObjectMapper");
            }
            PartyObjectMapper mapper = (PartyObjectMapper)objectCodec;
            if (StringsKt.contains$default((CharSequence)parser.getText(), (CharSequence)"=", (boolean)false, (int)2, null)) {
                String string = parser.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
                CordaX500Name principal = CordaX500Name.Companion.parse(string);
                party = mapper.wellKnownPartyFromX500Name(principal);
                if (party == null) {
                    throw (Throwable)new JsonParseException(parser, "Could not find a Party with name " + principal);
                }
            } else {
                String string = parser.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
                Set<Party> nameMatches = mapper.partiesFromName(string);
                if (nameMatches.isEmpty()) {
                    PublicKey publicKey;
                    try {
                        String string2 = parser.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"parser.text");
                        publicKey = EncodingUtils.parsePublicKeyBase58((String)string2);
                    }
                    catch (Exception e) {
                        throw (Throwable)new JsonParseException(parser, "Could not find a matching party for '" + parser.getText() + "' and is not a base58 encoded public key");
                    }
                    PublicKey key = publicKey;
                    party = mapper.partyFromKey(key);
                    if (party == null) {
                        throw (Throwable)new JsonParseException(parser, "Could not find a Party with key " + CryptoUtils.toStringShort((PublicKey)key));
                    }
                } else if (nameMatches.size() == 1) {
                    party = (Party)CollectionsKt.first((Iterable)nameMatches);
                } else {
                    Collection<CordaX500Name> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    JsonParseException jsonParseException;
                    Iterable key = nameMatches;
                    StringBuilder stringBuilder = new StringBuilder().append("Ambiguous name match '").append(parser.getText()).append("': could be any of ");
                    JsonParser jsonParser = parser;
                    JsonParseException jsonParseException2 = jsonParseException;
                    JsonParseException jsonParseException3 = jsonParseException;
                    void var6_7 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it;
                        Party party2 = (Party)item$iv$iv;
                        collection = destination$iv$iv;
                        CordaX500Name cordaX500Name = it.getName();
                        collection.add(cordaX500Name);
                    }
                    collection = (List)destination$iv$iv;
                    jsonParseException2(jsonParser, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ... or ...", null, null, (int)0, null, null, (int)62, null)).toString());
                    throw (Throwable)jsonParseException3;
                }
            }
            return party;
        }

        private PartyDeserializer() {
            INSTANCE = this;
        }

        static {
            new PartyDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$CordaX500NameSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/identity/CordaX500Name;", "()V", "serialize", "", "obj", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class CordaX500NameSerializer
    extends JsonSerializer<CordaX500Name> {
        public static final CordaX500NameSerializer INSTANCE;

        public void serialize(@NotNull CordaX500Name obj, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeString(obj.toString());
        }

        private CordaX500NameSerializer() {
            INSTANCE = this;
        }

        static {
            new CordaX500NameSerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$CordaX500NameDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/core/identity/CordaX500Name;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class CordaX500NameDeserializer
    extends JsonDeserializer<CordaX500Name> {
        public static final CordaX500NameDeserializer INSTANCE;

        @NotNull
        public CordaX500Name deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            CordaX500Name cordaX500Name;
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Intrinsics.areEqual((Object)parser.getCurrentToken(), (Object)JsonToken.FIELD_NAME)) {
                parser.nextToken();
            }
            try {
                String string = parser.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
                cordaX500Name = CordaX500Name.Companion.parse(string);
            }
            catch (IllegalArgumentException ex) {
                throw (Throwable)new JsonParseException(parser, "Invalid Corda X.500 name " + parser.getText() + ": " + ex.getMessage(), (Throwable)ex);
            }
            return cordaX500Name;
        }

        private CordaX500NameDeserializer() {
            INSTANCE = this;
        }

        static {
            new CordaX500NameDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$NodeInfoSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/node/NodeInfo;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class NodeInfoSerializer
    extends JsonSerializer<NodeInfo> {
        public static final NodeInfoSerializer INSTANCE;

        public void serialize(@NotNull NodeInfo value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializers, (String)"serializers");
            gen.writeString(Base58.encode((byte[])SerializationAPIKt.serialize$default((Object)value, null, null, (int)3, null).getBytes()));
        }

        private NodeInfoSerializer() {
            INSTANCE = this;
        }

        static {
            new NodeInfoSerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$NodeInfoDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/core/node/NodeInfo;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class NodeInfoDeserializer
    extends JsonDeserializer<NodeInfo> {
        public static final NodeInfoDeserializer INSTANCE;

        @NotNull
        public NodeInfo deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Intrinsics.areEqual((Object)parser.getCurrentToken(), (Object)JsonToken.FIELD_NAME)) {
                parser.nextToken();
            }
            try {
                byte[] $receiver$iv = Base58.decode((String)parser.getText());
                SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
                SerializationContext context$iv = serializationFactory$iv.getDefaultContext();
                ByteSequence $receiver$iv$iv = ByteArrays.sequence$default((byte[])$receiver$iv, (int)0, (int)0, (int)3, null);
                return (NodeInfo)serializationFactory$iv.deserialize($receiver$iv$iv, NodeInfo.class, context$iv);
            }
            catch (Exception e) {
                throw (Throwable)new JsonParseException(parser, "Invalid NodeInfo " + parser.getText() + ": " + e.getMessage());
            }
        }

        private NodeInfoDeserializer() {
            INSTANCE = this;
        }

        static {
            new NodeInfoDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$SecureHashSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/crypto/SecureHash;", "()V", "serialize", "", "obj", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class SecureHashSerializer
    extends JsonSerializer<SecureHash> {
        public static final SecureHashSerializer INSTANCE;

        public void serialize(@NotNull SecureHash obj, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeString(obj.toString());
        }

        private SecureHashSerializer() {
            INSTANCE = this;
        }

        static {
            new SecureHashSerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$SecureHashDeserializer;", "T", "Lnet/corda/core/crypto/SecureHash;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Lnet/corda/core/crypto/SecureHash;", "jackson_main"})
    public static final class SecureHashDeserializer<T extends SecureHash>
    extends JsonDeserializer<T> {
        @NotNull
        public T deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Intrinsics.areEqual((Object)parser.getCurrentToken(), (Object)JsonToken.FIELD_NAME)) {
                parser.nextToken();
            }
            try {
                String string = parser.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
                SecureHash.SHA256 sHA256 = SecureHash.Companion.parse(string);
                if (sHA256 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                return (T)((SecureHash)sHA256);
            }
            catch (Exception e) {
                throw (Throwable)new JsonParseException(parser, "Invalid hash " + parser.getText() + ": " + e.getMessage());
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$PublicKeySerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/i2p/crypto/eddsa/EdDSAPublicKey;", "()V", "serialize", "", "obj", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class PublicKeySerializer
    extends JsonSerializer<EdDSAPublicKey> {
        public static final PublicKeySerializer INSTANCE;

        public void serialize(@NotNull EdDSAPublicKey obj, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            boolean bl = Intrinsics.areEqual((Object)obj.getParams(), (Object)Crypto.EDDSA_ED25519_SHA512.getAlgSpec());
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            generator.writeString(EncodingUtils.toBase58String((PublicKey)((PublicKey)obj)));
        }

        private PublicKeySerializer() {
            INSTANCE = this;
        }

        static {
            new PublicKeySerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$PublicKeyDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/i2p/crypto/eddsa/EdDSAPublicKey;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class PublicKeyDeserializer
    extends JsonDeserializer<EdDSAPublicKey> {
        public static final PublicKeyDeserializer INSTANCE;

        @NotNull
        public EdDSAPublicKey deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            EdDSAPublicKey edDSAPublicKey;
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                String string = parser.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
                PublicKey publicKey = EncodingUtils.parsePublicKeyBase58((String)string);
                if (publicKey == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.i2p.crypto.eddsa.EdDSAPublicKey");
                }
                edDSAPublicKey = (EdDSAPublicKey)publicKey;
            }
            catch (Exception e) {
                throw (Throwable)new JsonParseException(parser, "Invalid public key " + parser.getText() + ": " + e.getMessage());
            }
            return edDSAPublicKey;
        }

        private PublicKeyDeserializer() {
            INSTANCE = this;
        }

        static {
            new PublicKeyDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$CompositeKeySerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/crypto/CompositeKey;", "()V", "serialize", "", "obj", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class CompositeKeySerializer
    extends JsonSerializer<CompositeKey> {
        public static final CompositeKeySerializer INSTANCE;

        public void serialize(@NotNull CompositeKey obj, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeString(EncodingUtils.toBase58String((PublicKey)((PublicKey)obj)));
        }

        private CompositeKeySerializer() {
            INSTANCE = this;
        }

        static {
            new CompositeKeySerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$CompositeKeyDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/core/crypto/CompositeKey;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class CompositeKeyDeserializer
    extends JsonDeserializer<CompositeKey> {
        public static final CompositeKeyDeserializer INSTANCE;

        @NotNull
        public CompositeKey deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            CompositeKey compositeKey;
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                String string = parser.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
                PublicKey publicKey = EncodingUtils.parsePublicKeyBase58((String)string);
                if (publicKey == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.core.crypto.CompositeKey");
                }
                compositeKey = (CompositeKey)publicKey;
            }
            catch (Exception e) {
                throw (Throwable)new JsonParseException(parser, "Invalid composite key " + parser.getText() + ": " + e.getMessage());
            }
            return compositeKey;
        }

        private CompositeKeyDeserializer() {
            INSTANCE = this;
        }

        static {
            new CompositeKeyDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$AmountSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/contracts/Amount;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class AmountSerializer
    extends JsonSerializer<Amount<?>> {
        public static final AmountSerializer INSTANCE;

        public void serialize(@NotNull Amount<?> value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializers, (String)"serializers");
            gen.writeString(value.toString());
        }

        private AmountSerializer() {
            INSTANCE = this;
        }

        static {
            new AmountSerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$AmountDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/core/contracts/Amount;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class AmountDeserializer
    extends JsonDeserializer<Amount<?>> {
        public static final AmountDeserializer INSTANCE;

        @NotNull
        public Amount<?> deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                String string = parser.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.text");
                return Amount.Companion.parseCurrency(string);
            }
            catch (Exception e) {
                try {
                    boolean bl;
                    CharSequence charSequence;
                    JsonNode tree = (JsonNode)parser.readValueAsTree();
                    boolean bl2 = tree.get("quantity").canConvertToLong() && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)tree.get("token").asText())) ? true : (bl = false);
                    if (!bl) {
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    long quantity = tree.get("quantity").asLong();
                    String token = tree.get("token").asText();
                    Currency currency = Currency.getInstance(token);
                    return new Amount(quantity, (Object)currency);
                }
                catch (Exception e2) {
                    throw (Throwable)new JsonParseException(parser, "Invalid amount " + parser.getText(), (Throwable)e2);
                }
            }
        }

        private AmountDeserializer() {
            INSTANCE = this;
        }

        static {
            new AmountDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/corda/client/jackson/JacksonSupport$OpaqueBytesDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/core/utilities/OpaqueBytes;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson_main"})
    public static final class OpaqueBytesDeserializer
    extends JsonDeserializer<OpaqueBytes> {
        public static final OpaqueBytesDeserializer INSTANCE;

        @NotNull
        public OpaqueBytes deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt) {
            OpaqueBytes opaqueBytes;
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            String string = parser.getText();
            OpaqueBytes opaqueBytes2 = opaqueBytes;
            OpaqueBytes opaqueBytes3 = opaqueBytes;
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            opaqueBytes2(byArray2);
            return opaqueBytes3;
        }

        private OpaqueBytesDeserializer() {
            INSTANCE = this;
        }

        static {
            new OpaqueBytesDeserializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$OpaqueBytesSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lnet/corda/core/utilities/OpaqueBytes;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jackson_main"})
    public static final class OpaqueBytesSerializer
    extends JsonSerializer<OpaqueBytes> {
        public static final OpaqueBytesSerializer INSTANCE;

        public void serialize(@NotNull OpaqueBytes value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializers, (String)"serializers");
            gen.writeBinary(value.getBytes());
        }

        private OpaqueBytesSerializer() {
            INSTANCE = this;
        }

        static {
            new OpaqueBytesSerializer();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H'J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H'J\n\u0010\b\u001a\u0004\u0018\u00010\tH'J\b\u0010\n\u001a\u00020\u000bH'J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH'J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H%J\b\u0010\u0011\u001a\u00020\u0012H%J\b\u0010\u0013\u001a\u00020\u0014H'J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H'\u00a8\u0006\u0017"}, d2={"Lnet/corda/client/jackson/JacksonSupport$SignedTransactionMixin;", "", "()V", "getId", "Lnet/corda/core/crypto/SecureHash;", "getInputs", "", "Lnet/corda/core/contracts/StateRef;", "getNotary", "Lnet/corda/core/identity/Party;", "getNotaryChangeTx", "Lnet/corda/core/transactions/NotaryChangeWireTransaction;", "getRequiredSigningKeys", "", "Ljava/security/PublicKey;", "getSigs", "Lnet/corda/core/crypto/TransactionSignature;", "getTransaction", "Lnet/corda/core/transactions/CoreTransaction;", "getTx", "Lnet/corda/core/transactions/WireTransaction;", "getTxBits", "Lnet/corda/core/serialization/SerializedBytes;", "jackson_main"})
    public static abstract class SignedTransactionMixin {
        @JsonIgnore
        @NotNull
        public abstract SerializedBytes<CoreTransaction> getTxBits();

        @JsonProperty(value="signatures")
        @NotNull
        protected abstract List<TransactionSignature> getSigs();

        @JsonProperty
        @NotNull
        protected abstract CoreTransaction getTransaction();

        @JsonIgnore
        @NotNull
        public abstract WireTransaction getTx();

        @JsonIgnore
        @NotNull
        public abstract NotaryChangeWireTransaction getNotaryChangeTx();

        @JsonIgnore
        @NotNull
        public abstract List<StateRef> getInputs();

        @JsonIgnore
        @Nullable
        public abstract Party getNotary();

        @JsonIgnore
        @NotNull
        public abstract SecureHash getId();

        @JsonIgnore
        @NotNull
        public abstract Set<PublicKey> getRequiredSigningKeys();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H'J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H'J\b\u0010\u0007\u001a\u00020\bH'J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004H'\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jackson/JacksonSupport$WireTransactionMixin;", "", "()V", "getAvailableComponentHashes", "", "Lnet/corda/core/crypto/SecureHash;", "getAvailableComponents", "getMerkleTree", "Lnet/corda/core/crypto/MerkleTree;", "getOutputStates", "Lnet/corda/core/contracts/ContractState;", "jackson_main"})
    public static abstract class WireTransactionMixin {
        @JsonIgnore
        @NotNull
        public abstract MerkleTree getMerkleTree();

        @JsonIgnore
        @NotNull
        public abstract List<Object> getAvailableComponents();

        @JsonIgnore
        @NotNull
        public abstract List<SecureHash> getAvailableComponentHashes();

        @JsonIgnore
        @NotNull
        public abstract List<ContractState> getOutputStates();
    }
}

