/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.Segment;
import java.io.IOException;
import java.io.Writer;

final class CharOutputSegment
implements OutputSegment {
    private final int begin;
    private final int end;
    private final char ch;

    public CharOutputSegment(int begin, int end, char ch) {
        this.begin = begin;
        this.end = end;
        this.ch = ch;
    }

    public CharOutputSegment(Segment segment, char ch) {
        this.begin = segment.begin;
        this.end = segment.end;
        this.ch = ch;
    }

    public CharOutputSegment(CharacterReference characterReference) {
        this(characterReference, characterReference.getChar());
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.ch);
    }

    public long getEstimatedMaximumOutputLength() {
        return 1L;
    }

    public String toString() {
        return Character.toString(this.ch);
    }

    public String getDebugInfo() {
        return "Replace: (p" + this.begin + "-p" + this.end + ") " + this.ch;
    }
}

