/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharStreamSource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;

public final class CharStreamSourceUtil {
    private static final int DEFAULT_ESTIMATED_MAXIMUM_OUTPUT_LENGTH = 2048;

    private CharStreamSourceUtil() {
    }

    public static Reader getReader(CharStreamSource charStreamSource) {
        return new StringReader(CharStreamSourceUtil.toString(charStreamSource));
    }

    public static String toString(CharStreamSource charStreamSource) {
        long estimatedMaximumOutputLength = charStreamSource.getEstimatedMaximumOutputLength();
        if (estimatedMaximumOutputLength <= -1L) {
            estimatedMaximumOutputLength = 2048L;
        }
        StringWriter writer = new StringWriter((int)estimatedMaximumOutputLength);
        try {
            charStreamSource.writeTo(writer);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return writer.toString();
    }
}

