/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;

public final class EndTag
extends Tag {
    private final EndTagType endTagType;

    EndTag(Source source, int begin, int end, EndTagType endTagType, String name) {
        super(source, begin, end, name);
        this.endTagType = endTagType;
    }

    public Element getElement() {
        StartTag startTag;
        if (this.element != Element.NOT_CACHED) {
            return this.element;
        }
        int pos = this.begin;
        while (pos != 0 && (startTag = this.source.findPreviousStartTag(pos - 1)) != null) {
            Element foundElement = startTag.getElement();
            if (foundElement.getEndTag() == this) {
                return foundElement;
            }
            pos = startTag.begin;
        }
        this.element = null;
        return null;
    }

    public EndTagType getEndTagType() {
        return this.endTagType;
    }

    public TagType getTagType() {
        return this.endTagType;
    }

    public boolean isUnregistered() {
        return this.endTagType == EndTagType.UNREGISTERED;
    }

    public String tidy() {
        return this.toString();
    }

    public static String generateHTML(String tagName) {
        return EndTagType.NORMAL.generateHTML(tagName);
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append((Object)this).append(' ');
        if (this.endTagType != EndTagType.NORMAL) {
            sb.append('(').append(this.endTagType.getDescription()).append(") ");
        }
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    static EndTag findPrevious(Source source, int pos, String name, EndTagType endTagType) {
        if (name == null) {
            return (EndTag)Tag.findPreviousTag(source, pos, endTagType);
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        String searchString = "</" + name;
        ParseText parseText = source.getParseText();
        int begin = pos;
        do {
            if ((begin = parseText.lastIndexOf(searchString, begin)) == -1) {
                return null;
            }
            EndTag endTag = (EndTag)source.getTagAt(begin);
            if (endTag == null || endTag.getEndTagType() != endTagType || !name.equals(endTag.getName())) continue;
            return endTag;
        } while (--begin >= 0);
        return null;
    }

    static EndTag findNext(Source source, int pos, String name, EndTagType endTagType) {
        if (name == null) {
            return (EndTag)Tag.findNextTag(source, pos, endTagType);
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        String searchString = "</" + name;
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.indexOf(searchString, begin)) == -1) {
                    return null;
                }
                EndTag endTag = (EndTag)source.getTagAt(begin);
                if (endTag == null || endTag.getEndTagType() != endTagType || !name.equals(endTag.getName())) continue;
                return endTag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static EndTag findPrevious(Source source, int pos) {
        Tag tag;
        while ((tag = Tag.findPreviousTag(source, pos)) != null) {
            if (tag instanceof EndTag) {
                return (EndTag)tag;
            }
            --pos;
        }
        return null;
    }

    static EndTag findNext(Source source, int pos) {
        Tag tag;
        while ((tag = Tag.findNextTag(source, pos)) != null) {
            if (tag instanceof EndTag) {
                return (EndTag)tag;
            }
            ++pos;
        }
        return null;
    }
}

