/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.NodeIterator;
import au.id.jericho.lib.html.Renderer;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import au.id.jericho.lib.html.TextExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Segment
implements Comparable,
CharSequence {
    final int begin;
    final int end;
    final Source source;
    List childElements = null;
    private static final char[] WHITESPACE = new char[]{' ', '\n', '\r', '\t', '\f', '\u200b'};

    public Segment(Source source, int begin, int end) {
        if (begin == -1 || end == -1 || begin > end) {
            throw new IllegalArgumentException();
        }
        this.begin = begin;
        this.end = end;
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int length) {
        this.begin = 0;
        this.end = length;
        this.source = (Source)this;
    }

    Segment() {
        this.begin = 0;
        this.end = 0;
        this.source = null;
    }

    public final Source getSource() {
        return this.source;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    public final int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int pos) {
        return this.begin <= pos && pos < this.end;
    }

    public String toString() {
        return this.source.string.substring(this.begin, this.end).toString();
    }

    public Renderer getRenderer() {
        return new Renderer(this);
    }

    public TextExtractor getTextExtractor() {
        return new TextExtractor(this);
    }

    public Iterator getNodeIterator() {
        return new NodeIterator(this);
    }

    public List findAllTags() {
        return this.findAllTags(null);
    }

    public List findAllTags(TagType tagType) {
        Tag tag = this.checkEnclosure(Tag.findNextTag(this.source, this.begin, tagType));
        if (tag == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        do {
            list.add(tag);
        } while ((tag = this.checkEnclosure(tagType == null ? tag.findNextTag() : Tag.findNextTag(this.source, tag.begin + 1, tagType))) != null);
        return list;
    }

    public List findAllStartTags() {
        return this.findAllStartTags(null);
    }

    public List findAllStartTags(String name) {
        boolean isXMLTagName;
        StartTag startTag;
        if (name != null) {
            name = name.toLowerCase();
        }
        if ((startTag = (StartTag)this.checkEnclosure(StartTag.findNext(this.source, this.begin, name, StartTagType.NORMAL, isXMLTagName = Tag.isXMLName(name)))) == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(StartTag.findNext(this.source, startTag.begin + 1, name, StartTagType.NORMAL, isXMLTagName))) != null);
        return list;
    }

    public List findAllStartTags(String attributeName, String value, boolean valueCaseSensitive) {
        StartTag startTag = (StartTag)this.checkEnclosure(this.source.findNextStartTag(this.begin, attributeName, value, valueCaseSensitive));
        if (startTag == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(this.source.findNextStartTag(startTag.begin + 1, attributeName, value, valueCaseSensitive))) != null);
        return list;
    }

    public List getChildElements() {
        if (this.childElements == null) {
            if (this.length() == 0) {
                this.childElements = Collections.EMPTY_LIST;
            } else {
                StartTag childStartTag;
                this.childElements = new ArrayList();
                int pos = this.begin;
                while ((childStartTag = this.source.findNextStartTag(pos)) != null && childStartTag.begin < this.end) {
                    if (childStartTag.getTagType().isServerTag()) {
                        pos = childStartTag.end;
                        continue;
                    }
                    Element childElement = childStartTag.getElement();
                    this.childElements.add(childElement);
                    childElement.getChildElements();
                    pos = childElement.end;
                }
            }
        }
        return this.childElements;
    }

    public List findAllElements() {
        return this.findAllElements((String)null);
    }

    public List findAllElements(String name) {
        List startTags;
        if (name != null) {
            name = name.toLowerCase();
        }
        if ((startTags = this.findAllStartTags(name)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> elements = new ArrayList<Element>(startTags.size());
        Iterator i = startTags.iterator();
        while (i.hasNext()) {
            StartTag startTag = (StartTag)i.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            elements.add(element);
        }
        return elements;
    }

    public List findAllElements(StartTagType startTagType) {
        List startTags = this.findAllTags(startTagType);
        if (startTags.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> elements = new ArrayList<Element>(startTags.size());
        Iterator i = startTags.iterator();
        while (i.hasNext()) {
            StartTag startTag = (StartTag)i.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            elements.add(element);
        }
        return elements;
    }

    public List findAllElements(String attributeName, String value, boolean valueCaseSensitive) {
        List startTags = this.findAllStartTags(attributeName, value, valueCaseSensitive);
        if (startTags.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> elements = new ArrayList<Element>(startTags.size());
        Iterator i = startTags.iterator();
        while (i.hasNext()) {
            StartTag startTag = (StartTag)i.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            elements.add(element);
        }
        return elements;
    }

    public List findAllCharacterReferences() {
        CharacterReference characterReference = this.findNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CharacterReference> list = new ArrayList<CharacterReference>();
        do {
            list.add(characterReference);
        } while ((characterReference = this.findNextCharacterReference(characterReference.end)) != null);
        return list;
    }

    public List findFormControls() {
        return FormControl.findAll(this);
    }

    public FormFields findFormFields() {
        return new FormFields(this.findFormControls());
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        Segment segment = (Segment)o;
        if (this.begin < segment.begin) {
            return -1;
        }
        if (this.begin > segment.begin) {
            return 1;
        }
        if (this.end < segment.end) {
            return -1;
        }
        if (this.end > segment.end) {
            return 1;
        }
        return 0;
    }

    public final boolean isWhiteSpace() {
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhiteSpace(char ch) {
        for (int i = 0; i < WHITESPACE.length; ++i) {
            if (ch != WHITESPACE[i]) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer(50);
        sb.append('(');
        this.source.getRowColumnVector(this.begin).appendTo(sb);
        sb.append('-');
        this.source.getRowColumnVector(this.end).appendTo(sb);
        sb.append(')');
        return sb.toString();
    }

    public final char charAt(int index) {
        return this.source.string.charAt(this.begin + index);
    }

    public final CharSequence subSequence(int beginIndex, int endIndex) {
        return this.source.string.subSequence(this.begin + beginIndex, this.begin + endIndex);
    }

    public String extractText() {
        return new TextExtractor(this).toString();
    }

    public String extractText(boolean includeAttributes) {
        return new TextExtractor(this).setIncludeAttributes(includeAttributes).toString();
    }

    static final StringBuffer appendCollapseWhiteSpace(StringBuffer sb, CharSequence text) {
        int textLength = text.length();
        int i = 0;
        boolean lastWasWhiteSpace = false;
        while (true) {
            if (i >= textLength) {
                return sb;
            }
            if (!Segment.isWhiteSpace(text.charAt(i))) break;
            ++i;
        }
        do {
            char ch;
            if (Segment.isWhiteSpace(ch = text.charAt(i++))) {
                lastWasWhiteSpace = true;
                continue;
            }
            if (lastWasWhiteSpace) {
                sb.append(' ');
                lastWasWhiteSpace = false;
            }
            sb.append(ch);
        } while (i < textLength);
        return sb;
    }

    private Tag checkEnclosure(Tag tag) {
        if (tag == null || tag.end > this.end) {
            return null;
        }
        return tag;
    }

    private CharacterReference findNextCharacterReference(int pos) {
        CharacterReference characterReference = this.source.findNextCharacterReference(pos);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

