/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.ws.rs;

import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.core.io.MemoryStore;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.Obfuscate;
import net.java.truelicense.ws.rs.LicenseConsumerServiceException;

@Path(value="license")
@Produces(value={"application/json", "application/xml", "text/xml"})
@Immutable
public final class LicenseConsumerService {
    private static final int BAD_REQUEST_STATUS_CODE = 400;
    private static final int PAYMENT_REQUIRED_STATUS_CODE = 402;
    private static final int NOT_FOUND_STATUS_CODE = 404;
    @Obfuscate
    private static final String SUBJECT = "subject";
    private static final QName subject = new QName("subject");
    private final LicenseConsumerManager manager;

    public LicenseConsumerService(@Context Providers providers) {
        this(LicenseConsumerService.manager(providers));
    }

    private static LicenseConsumerManager manager(Providers providers) {
        ContextResolver contextResolver = providers.getContextResolver(LicenseConsumerManager.class, MediaType.WILDCARD_TYPE);
        if (null == contextResolver) {
            throw new IllegalArgumentException("No @Provider annotated ContextResolver<LicenseConsumerManager> available.");
        }
        return (LicenseConsumerManager)contextResolver.getContext(LicenseConsumerManager.class);
    }

    @Inject
    public LicenseConsumerService(LicenseConsumerManager licenseConsumerManager) {
        this.manager = (LicenseConsumerManager)Objects.requireNonNull((Object)licenseConsumerManager);
    }

    LicenseConsumerManager manager() {
        return this.manager;
    }

    @GET
    @Path(value="subject")
    @Produces(value={"application/json"})
    public String subjectAsJson() {
        return '\"' + this.subject() + '\"';
    }

    @GET
    @Path(value="subject")
    @Produces(value={"application/xml", "text/xml"})
    public JAXBElement<String> subjectAsXml() {
        return new JAXBElement(subject, String.class, (Object)this.subject());
    }

    @GET
    @Path(value="subject")
    @Produces(value={"text/plain"})
    public String subject() {
        return this.manager().subject();
    }

    @POST
    public void install(byte[] byArray) throws LicenseConsumerServiceException {
        MemoryStore memoryStore = new MemoryStore();
        memoryStore.data(byArray);
        try {
            this.manager().install((Source)memoryStore);
        }
        catch (LicenseManagementException licenseManagementException) {
            throw new LicenseConsumerServiceException(400, licenseManagementException);
        }
    }

    @GET
    public License view(@QueryParam(value="verify") @DefaultValue(value="false") boolean bl) throws LicenseConsumerServiceException {
        License license;
        try {
            license = this.manager().view();
        }
        catch (LicenseManagementException licenseManagementException) {
            throw new LicenseConsumerServiceException(404, licenseManagementException);
        }
        if (bl) {
            try {
                this.manager().verify();
            }
            catch (LicenseManagementException licenseManagementException) {
                throw new LicenseConsumerServiceException(402, licenseManagementException);
            }
        }
        return license;
    }

    @DELETE
    public void uninstall() throws LicenseConsumerServiceException {
        try {
            this.manager().uninstall();
        }
        catch (LicenseManagementException licenseManagementException) {
            throw new LicenseConsumerServiceException(404, licenseManagementException);
        }
    }
}

