/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Duration;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.annotation.Nullable;

public final class LockExtender {
    private static final ThreadLocal<Deque<SimpleLock>> activeLocks = ThreadLocal.withInitial(LinkedList::new);

    private LockExtender() {
    }

    public static void extendActiveLock(Duration lockAtMostFor, Duration lockAtLeastFor) {
        SimpleLock lock = LockExtender.locks().peekLast();
        if (lock == null) {
            throw new NoActiveLockException();
        }
        Optional<SimpleLock> newLock = lock.extend(lockAtMostFor, lockAtLeastFor);
        if (!newLock.isPresent()) {
            throw new LockCanNotBeExtendedException();
        }
        LockExtender.locks().removeLast();
        LockExtender.locks().addLast(newLock.get());
    }

    private static Deque<SimpleLock> locks() {
        return activeLocks.get();
    }

    static void startLock(SimpleLock lock) {
        LockExtender.locks().addLast(lock);
    }

    @Nullable
    static SimpleLock endLock() {
        SimpleLock lock = LockExtender.locks().pollLast();
        if (LockExtender.locks().isEmpty()) {
            activeLocks.remove();
        }
        return lock;
    }

    public static class NoActiveLockException
    extends LockExtensionException {
        public NoActiveLockException() {
            super("No active lock in current thread, please make sure that you execute LockExtender.extendActiveLock in locked context.");
        }
    }

    public static class LockCanNotBeExtendedException
    extends LockExtensionException {
        public LockCanNotBeExtendedException() {
            super("Lock can not be extended, most likely it already expired.");
        }
    }

    public static class LockExtensionException
    extends RuntimeException {
        public LockExtensionException(String message) {
            super(message);
        }
    }
}

