/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import net.karneim.pojobuilder.analysis.Directives;
import net.karneim.pojobuilder.analysis.InvalidElementException;
import net.karneim.pojobuilder.analysis.JavaModelAnalyzerUtil;

public class DirectivesFactory {
    private final Elements elements;
    private final Types types;
    private final JavaModelAnalyzerUtil javaModelAnalyzerUtil;

    public DirectivesFactory(Elements elements, Types types, JavaModelAnalyzerUtil javaModelAnalyzerUtil) {
        this.elements = elements;
        this.types = types;
        this.javaModelAnalyzerUtil = javaModelAnalyzerUtil;
    }

    public Directives getDirectives(Element annotatedEl, Set<Element> orginatingElements) {
        List<HierarchyElement> hierarchy = this.findAnnotationHierarchy(annotatedEl);
        List<HierarchyElement> relevantHierarchy = this.filterByType(hierarchy, GeneratePojoBuilder.class);
        Map<String, Object> valueMap = this.getValueMap(relevantHierarchy);
        this.fillOrginatingElements(orginatingElements, hierarchy);
        Directives result = new Directives(valueMap);
        this.validate(annotatedEl, result);
        return result;
    }

    private List<HierarchyElement> filterByType(List<HierarchyElement> hierarchy, Class<GeneratePojoBuilder> class1) {
        TypeMirror generatePojoBuilderAnno = this.elements.getTypeElement(class1.getName()).asType();
        ArrayList<HierarchyElement> result = new ArrayList<HierarchyElement>();
        for (HierarchyElement el : hierarchy) {
            if (!this.types.isSameType(el.annotation.getAnnotationType(), generatePojoBuilderAnno)) continue;
            result.add(el);
        }
        return result;
    }

    private void fillOrginatingElements(Set<Element> result, List<HierarchyElement> hierarchy) {
        for (HierarchyElement hierarchyElement : hierarchy) {
            result.add(this.javaModelAnalyzerUtil.getCompilationUnit(hierarchyElement.annotatedEl));
        }
    }

    private void validate(Element annotatedEl, Directives directives) {
        if (directives.isGenerateBuilderProperties() && Void.class.getName().equals(directives.getBuilderInterfaceName())) {
            String message = String.format("Value for \"withBuilderInterface\" not specified. When setting \"withBuilderProperties\" to true, you must also specifiy a valid builder interface.", new Object[0]);
            throw new InvalidElementException(message, annotatedEl);
        }
    }

    private List<HierarchyElement> findAnnotationHierarchy(Element annotatedEl) {
        HashSet<Element> visitedElements = new HashSet<Element>();
        LinkedList<HierarchyElement> result = new LinkedList<HierarchyElement>();
        this.findAnnotationHierarchy(annotatedEl, result, visitedElements);
        return result;
    }

    private void findAnnotationHierarchy(Element annotatedEl, List<HierarchyElement> result, Set<Element> visitedElements) {
        if (!visitedElements.add(annotatedEl)) {
            return;
        }
        List<? extends AnnotationMirror> annos = annotatedEl.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annos) {
            Element el = annotationMirror.getAnnotationType().asElement();
            this.findAnnotationHierarchy(el, result, visitedElements);
            HierarchyElement hElem = new HierarchyElement(annotatedEl, annotationMirror);
            result.add(hElem);
        }
    }

    private boolean isGeneratePojoBuilderAnnotation(AnnotationMirror anno) {
        TypeElement generatePojoBuilderTypeEl = this.elements.getTypeElement(GeneratePojoBuilder.class.getName());
        return this.types.isSameType(anno.getAnnotationType(), generatePojoBuilderTypeEl.asType());
    }

    private Map<String, Object> getValueMap(List<HierarchyElement> hierarchy) {
        Map<String, Object> result = null;
        for (HierarchyElement el : hierarchy) {
            if (!this.isGeneratePojoBuilderAnnotation(el.annotation)) continue;
            if (result == null) {
                result = this.getValueMap(this.elements.getElementValuesWithDefaults(el.annotation));
                continue;
            }
            result.putAll(this.getValueMap(el.annotation.getElementValues()));
        }
        return result;
    }

    private Map<String, Object> getValueMap(Map<? extends ExecutableElement, ? extends AnnotationValue> values) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            Object value = entry.getValue().getValue();
            if (value instanceof TypeMirror) {
                TypeMirror tm = (TypeMirror)value;
                if (tm.getKind() == TypeKind.DECLARED) {
                    DeclaredType declType = (DeclaredType)tm;
                    TypeElement elem = (TypeElement)declType.asElement();
                    result.put(name, elem.getQualifiedName().toString());
                    continue;
                }
                result.put(name, String.valueOf(value));
                continue;
            }
            result.put(name, value);
        }
        return result;
    }

    private static class HierarchyElement {
        Element annotatedEl;
        AnnotationMirror annotation;

        public HierarchyElement(Element annotatedEl, AnnotationMirror annotation) {
            this.annotatedEl = annotatedEl;
            this.annotation = annotation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.annotatedEl == null ? 0 : this.annotatedEl.hashCode());
            result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HierarchyElement other = (HierarchyElement)obj;
            if (this.annotatedEl == null ? other.annotatedEl != null : !this.annotatedEl.equals(other.annotatedEl)) {
                return false;
            }
            return !(this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation));
        }

        public String toString() {
            return "HierarchyElement [annotatedEl=" + this.annotatedEl + ", annotation=" + this.annotation + "]";
        }
    }
}

