/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.processor;

import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import net.karneim.pojobuilder.analysis.AnnotationHierarchyUtil;
import net.karneim.pojobuilder.analysis.DirectivesFactory;
import net.karneim.pojobuilder.analysis.Input;
import net.karneim.pojobuilder.analysis.InputFactory;
import net.karneim.pojobuilder.analysis.InvalidElementException;
import net.karneim.pojobuilder.analysis.JavaModelAnalyzer;
import net.karneim.pojobuilder.analysis.JavaModelAnalyzerUtil;
import net.karneim.pojobuilder.analysis.Output;
import net.karneim.pojobuilder.model.BuilderM;
import net.karneim.pojobuilder.model.ManualBuilderM;
import net.karneim.pojobuilder.sourcegen.BuilderSourceGenerator;
import net.karneim.pojobuilder.sourcegen.ManualBuilderSourceGenerator;

public class AnnotationProcessor
extends AbstractProcessor {
    private static final Logger LOG = Logger.getLogger(AnnotationProcessor.class.getName());
    private JavaModelAnalyzer javaModelAnalyzer;
    private InputFactory inputFactory;
    private JavaModelAnalyzerUtil javaModelAnalyzerUtil;
    private AnnotationHierarchyUtil annotationHierarchyUtil;
    private final Set<String> failedTypeNames = new HashSet<String>();
    private final Set<String> generatedTypeNames = new HashSet<String>();
    private final Map<Element, Exception> failedElementsMap = new HashMap<Element, Exception>();
    private static final boolean ANNOTATIONS_NOT_CLAIMED_EXCLUSIVELY = false;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> result = new HashSet<String>();
        result.add("*");
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void initHelpers(ProcessingEnvironment env) {
        this.javaModelAnalyzerUtil = new JavaModelAnalyzerUtil(env.getElementUtils(), env.getTypeUtils());
        this.javaModelAnalyzer = new JavaModelAnalyzer(env.getElementUtils(), env.getTypeUtils(), this.javaModelAnalyzerUtil);
        this.inputFactory = new InputFactory(env.getTypeUtils(), new DirectivesFactory(env.getElementUtils(), env.getTypeUtils(), this.javaModelAnalyzerUtil));
        this.annotationHierarchyUtil = new AnnotationHierarchyUtil(env.getTypeUtils());
    }

    private void clearState() {
        this.javaModelAnalyzerUtil = null;
        this.javaModelAnalyzer = null;
        this.inputFactory = null;
        this.annotationHierarchyUtil = null;
        this.failedTypeNames.clear();
        this.generatedTypeNames.clear();
        this.failedElementsMap.clear();
    }

    @Override
    public boolean process(Set<? extends TypeElement> aAnnotations, RoundEnvironment aRoundEnv) {
        try {
            this.initHelpers(this.processingEnv);
            if (!aRoundEnv.processingOver()) {
                this.note("[PojoBuilder] Processing annotations");
                if (!aAnnotations.isEmpty()) {
                    Set<TypeElement> triggeringAnnotations = this.annotationHierarchyUtil.filterTriggeringAnnotations(aAnnotations, this.getTypeElement(GeneratePojoBuilder.class));
                    List<Element> elementsToProcess = this.getAnnotatedElements(aRoundEnv, triggeringAnnotations);
                    this.addElementsThatFailedInLastRound(elementsToProcess);
                    this.resetFailedElements();
                    ArrayList<Output> outputList = new ArrayList<Output>();
                    for (Element elem : elementsToProcess) {
                        try {
                            Input input = this.inputFactory.getInput(elem);
                            Output output = this.javaModelAnalyzer.analyze(input);
                            outputList.add(output);
                        }
                        catch (Exception ex) {
                            this.addFailedElement(elem, ex);
                        }
                    }
                    for (Output output : outputList) {
                        try {
                            this.generateSources(output);
                        }
                        catch (Exception ex) {
                            this.error(ex, output.getInput().getAnnotatedElement());
                        }
                    }
                }
            } else {
                this.note("[PojoBuilder] Finishing");
                this.showErrorsForFailedElements();
                this.clearState();
            }
        }
        catch (Throwable t) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.toString(t));
        }
        return false;
    }

    private void resetFailedElements() {
        this.failedElementsMap.clear();
        this.failedTypeNames.clear();
    }

    private void addElementsThatFailedInLastRound(List<Element> elementsToProcess) {
        elementsToProcess.addAll(this.javaModelAnalyzerUtil.findAnnotatedElements(this.getTypeElements(this.failedTypeNames), GeneratePojoBuilder.class));
    }

    private void addFailedElement(Element elem, Exception ex) {
        this.failedElementsMap.put(elem, ex);
        this.failedTypeNames.add(this.javaModelAnalyzerUtil.getCompilationUnit(elem).getQualifiedName().toString());
    }

    private void showErrorsForFailedElements() {
        for (Map.Entry<Element, Exception> entry : this.failedElementsMap.entrySet()) {
            this.error(entry.getValue(), entry.getKey());
        }
    }

    private List<Element> getAnnotatedElements(RoundEnvironment aRoundEnv, Set<TypeElement> triggeringAnnotations) {
        ArrayList<Element> elementsToProcess = new ArrayList<Element>();
        for (TypeElement annoTypeEl : triggeringAnnotations) {
            elementsToProcess.addAll(aRoundEnv.getElementsAnnotatedWith(annoTypeEl));
        }
        return this.removeAnnotationElements(elementsToProcess);
    }

    private List<Element> removeAnnotationElements(List<Element> elements) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element el : elements) {
            if (el.getKind() == ElementKind.ANNOTATION_TYPE) continue;
            result.add(el);
        }
        return result;
    }

    private TypeElement getTypeElement(Class<?> cls) {
        return this.getTypeElement(cls.getName());
    }

    private TypeElement getTypeElement(String typeName) {
        return this.processingEnv.getElementUtils().getTypeElement(typeName);
    }

    private Collection<TypeElement> getTypeElements(Collection<String> typeNames) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        for (String typeName : typeNames) {
            result.add(this.getTypeElement(typeName));
        }
        return result;
    }

    private void generateSources(Output output) throws IOException {
        if (!this.hasAlreadyBeenCreated(this.getTypeName(output.getBuilderModel()))) {
            this.generateBuilderImpl(output);
        }
        if (output.getManualBuilderModel() != null && !this.hasAlreadyBeenCreated(this.getTypeName(output.getManualBuilderModel())) && !this.typeExists(this.getTypeName(output.getManualBuilderModel()))) {
            this.generateManualBuilder(output);
        }
    }

    private boolean hasAlreadyBeenCreated(String typename) {
        return this.generatedTypeNames.contains(typename);
    }

    private void generateBuilderImpl(Output output) throws IOException {
        BuilderM builderModel = output.getBuilderModel();
        String qualifiedName = this.getTypeName(builderModel);
        JavaFileObject jobj = this.processingEnv.getFiler().createSourceFile(qualifiedName, this.asArray(output.getInput().getOrginatingElements()));
        Writer writer = jobj.openWriter();
        JavaWriter javaWriter = new JavaWriter(writer);
        BuilderSourceGenerator generator = new BuilderSourceGenerator(javaWriter);
        generator.generateSource(builderModel);
        writer.close();
        for (String warning : generator.getWarnings()) {
            this.warn(warning, output.getInput().getAnnotatedElement());
        }
        this.generatedTypeNames.add(qualifiedName);
        this.note(String.format("[PojoBuilder] Generated class %s", qualifiedName), null);
        LOG.fine(String.format("Generated %s", jobj.toUri()));
    }

    private Element[] asArray(Collection<Element> elements) {
        Element[] result = new Element[elements.size()];
        elements.toArray(result);
        return result;
    }

    private void generateManualBuilder(Output output) throws IOException {
        ManualBuilderM manualBuilderModel = output.getManualBuilderModel();
        String qualifiedName = this.getTypeName(manualBuilderModel);
        JavaFileObject jobj = this.processingEnv.getFiler().createSourceFile(qualifiedName, this.asArray(output.getInput().getOrginatingElements()));
        Writer writer = jobj.openWriter();
        JavaWriter javaWriter = new JavaWriter(writer);
        ManualBuilderSourceGenerator generator = new ManualBuilderSourceGenerator(javaWriter);
        generator.generateSource(manualBuilderModel);
        writer.close();
        this.generatedTypeNames.add(qualifiedName);
        this.note(String.format("[PojoBuilder] Generated class %s", qualifiedName), null);
        LOG.fine(String.format("Generated %s", jobj.toUri()));
    }

    private boolean typeExists(String qualifiedName) {
        return this.processingEnv.getElementUtils().getTypeElement(qualifiedName) != null;
    }

    private String getTypeName(ManualBuilderM manualBuilderModel) {
        String qualifiedName = manualBuilderModel.getType().getName();
        return qualifiedName;
    }

    private String getTypeName(BuilderM builderModel) {
        String qualifiedName = builderModel.getType().getName();
        return qualifiedName;
    }

    private void error(Exception ex, Element processedElement) {
        if (ex instanceof InvalidElementException) {
            InvalidElementException invElemEx = (InvalidElementException)ex;
            Element elem = invElemEx.getElement();
            this.error(invElemEx.getMessage(), elem);
        } else {
            String message = String.format("PojoBuilder caught unexpected exception on element %s!%s", processedElement, this.toString(ex));
            this.error(message, processedElement);
        }
    }

    private void error(String msg, Element element) {
        if (element.asType().getKind() != TypeKind.ERROR) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, null);
        }
        LOG.severe(msg);
    }

    private void note(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg, element);
    }

    private void note(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    private void warn(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, element);
    }

    private String toString(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        writer.append("\n");
        ex.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

