/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.sourcegen;

import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;
import net.karneim.pojobuilder.model.ArgumentListM;
import net.karneim.pojobuilder.model.ArrayTypeM;
import net.karneim.pojobuilder.model.BuildMethodM;
import net.karneim.pojobuilder.model.BuilderM;
import net.karneim.pojobuilder.model.CopyMethodM;
import net.karneim.pojobuilder.model.FactoryMethodM;
import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.PropertyListM;
import net.karneim.pojobuilder.model.PropertyM;
import net.karneim.pojobuilder.model.StaticFactoryMethodM;
import net.karneim.pojobuilder.model.TypeM;
import net.karneim.pojobuilder.model.ValidatorM;
import net.karneim.pojobuilder.model.WriteAccess;

public class BuilderSourceGenerator {
    private final JavaWriter writer;
    private final List<String> warnings = new ArrayList<String>();

    public BuilderSourceGenerator(JavaWriter writer) {
        this.writer = writer;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    private void addWarning(String messageFormat, Object ... args) {
        this.warnings.add(String.format(messageFormat, args));
    }

    public void generateSource(BuilderM builder) throws IOException {
        this.checkNotNull(builder.getPojoType(), "builder.getPojoType() must not be null");
        this.checkNotNull(builder.getType(), "builder.getBuilderType() must not be null");
        this.checkNotNull(builder.getProperties(), "builder.getProperties() must not be null");
        this.generateSource(builder.getType(), builder.isAbstract(), builder.getSelfType(), builder.getBaseType(), builder.getInterfaceType(), builder.hasBuilderProperties(), builder.getPojoType(), builder.getProperties(), builder.getBuildMethod(), builder.getFactoryMethod(), builder.getCopyMethod(), builder.getValidator(), builder.getOptionalType(), builder.getStaticFactoryMethod());
    }

    private void checkNotNull(Object obj, String errorMessage) {
        if (obj == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    private void generateSource(TypeM builderType, boolean isAbstract, TypeM selfType, TypeM baseType, TypeM interfaceType, boolean hasBuilderProperties, TypeM pojoType, PropertyListM properties, BuildMethodM buildMethod, FactoryMethodM factoryMethod, CopyMethodM copyMethodM, ValidatorM validator, TypeM optionalType, StaticFactoryMethodM staticFactoryMethod) throws IOException {
        String[] interfaces;
        String baseclass;
        properties = new PropertyListM(properties);
        properties.filterOutNonWritableProperties(builderType);
        ImportTypesM importTypes = pojoType.addToImportTypes(new ImportTypesM());
        if (factoryMethod != null) {
            factoryMethod.getDeclaringClass().addToImportTypes(importTypes);
        }
        properties.getTypes().addToImportTypes(importTypes);
        importTypes.add(Generated.class);
        if (optionalType != null) {
            optionalType.addToImportTypes(importTypes);
        }
        if (baseType == null || baseType.getName().equals("java.lang.Object")) {
            baseclass = null;
        } else {
            baseclass = baseType.getGenericTypeDeclaration();
            baseType.addToImportTypes(importTypes);
        }
        EnumSet<Modifier> builderTypeModifier = isAbstract ? EnumSet.of(Modifier.PUBLIC, Modifier.ABSTRACT) : EnumSet.of(Modifier.PUBLIC);
        if (interfaceType == null) {
            interfaces = new String[]{"Cloneable"};
        } else {
            interfaces = new String[]{interfaceType.getGenericTypeDeclaration(), "Cloneable"};
            interfaceType.addToImportTypes(importTypes);
        }
        if (validator != null) {
            validator.getType().addToImportTypes(importTypes);
        }
        importTypes.removePackage(builderType.getPackageName());
        importTypes.removePackage("java.lang");
        this.writer.emitPackage(builderType.getPackageName()).emitImports(importTypes.getSortedDistinctClassnames()).emitEmptyLine().emitAnnotation(Generated.class, (Object)JavaWriter.stringLiteral("PojoBuilder")).beginType(builderType.getGenericType(), "class", builderTypeModifier, baseclass, interfaces).emitField(selfType.getGenericTypeDeclaration(), "self", EnumSet.of(Modifier.PROTECTED));
        if (validator != null) {
            this.emitValidatorField(validator);
        }
        for (PropertyM prop : properties) {
            this.emitPropertyFields(prop, interfaceType, hasBuilderProperties);
        }
        if (staticFactoryMethod != null) {
            BuilderSourceGenerator.emitStaticFactoryMethod(selfType, staticFactoryMethod, this.writer);
        }
        this.emitConstructor(builderType, selfType);
        for (PropertyM prop : properties) {
            this.emitWithMethod(builderType, selfType, pojoType, prop);
            if (optionalType != null) {
                this.emitWithOptionalMethod(builderType, selfType, pojoType, prop, optionalType);
            }
            if (interfaceType == null || !hasBuilderProperties) continue;
            this.emitWithMethodUsingBuilderInterface(builderType, selfType, interfaceType, pojoType, prop);
        }
        this.emitCloneMethod(selfType);
        this.emitButMethod(selfType);
        if (copyMethodM != null) {
            if (properties.hasPropertiesReadablyBy(builderType)) {
                this.emitCopyMethod(builderType, selfType, pojoType, properties, copyMethodM);
            } else {
                this.addWarning("[PojoBuilder] Skipping the generation of %s method because none of the writable properties are readable!", copyMethodM.getName());
            }
        }
        this.emitBuildMethod(builderType, pojoType, interfaceType, hasBuilderProperties, properties, factoryMethod, buildMethod, validator);
        this.writer.endType();
    }

    private void emitValidatorField(ValidatorM validator) throws IOException {
        String validatorTypeDeclaration = this.writer.compressType(validator.getType().getGenericTypeDeclaration());
        String initialization = String.format("new %s()", validatorTypeDeclaration);
        this.writer.emitField(validatorTypeDeclaration, validator.getFieldName(), EnumSet.of(Modifier.PROTECTED), initialization);
    }

    static void emitStaticFactoryMethod(TypeM selfType, StaticFactoryMethodM method, JavaWriter writer) throws IOException {
        String returnTypeDecl;
        String builderTypeDeclaration = writer.compressType(selfType.getGenericTypeDeclaration());
        if (selfType.isGeneric()) {
            String typeParameters = "<" + writer.compressType(selfType.getTypeParameters().toParameterString()) + ">";
            returnTypeDecl = typeParameters + " " + builderTypeDeclaration;
        } else {
            returnTypeDecl = builderTypeDeclaration;
        }
        writer.emitEmptyLine().emitJavadoc("Factory Method to construct a %s\n\n@return a new %s", builderTypeDeclaration, builderTypeDeclaration).beginMethod(returnTypeDecl, method.getName(), method.getModifiers(), new String[0]).emitStatement("return new %s()", builderTypeDeclaration).endMethod();
    }

    private void emitCopyMethod(TypeM builderType, TypeM selfType, TypeM pojoType, PropertyListM properties, CopyMethodM copyMethodM) throws IOException {
        properties = new PropertyListM(properties);
        String selfTypeDeclaration = this.writer.compressType(selfType.getGenericTypeDeclaration());
        String pojoTypeDeclaration = this.writer.compressType(pojoType.getGenericTypeDeclaration());
        this.writer.emitEmptyLine().emitJavadoc("Copies the values from the given pojo into this builder.\n\n@param pojo\n@return this builder", new Object[0]).beginMethod(selfTypeDeclaration, copyMethodM.getName(), EnumSet.of(Modifier.PUBLIC), pojoTypeDeclaration, "pojo");
        PropertyListM getterProperties = properties.filterOutPropertiesReadableViaGetterCall(builderType);
        for (PropertyM prop : getterProperties) {
            String withMethodName = prop.getWithMethodName();
            this.writer.emitStatement("%s(pojo.%s())", withMethodName, prop.getGetterMethod().getName());
        }
        PropertyListM readableFieldProperties = properties.filterOutPropertiesReadableViaFieldAccess(builderType);
        for (PropertyM prop : readableFieldProperties) {
            String withMethodName = prop.getWithMethodName();
            this.writer.emitStatement("%s(pojo.%s)", withMethodName, prop.getPropertyName());
        }
        this.writer.emitStatement("return self", new Object[0]);
        this.writer.endMethod();
    }

    private void emitBuildMethod(TypeM builderType, TypeM pojoType, TypeM interfaceType, boolean hasBuilderProperties, PropertyListM properties, FactoryMethodM factoryMethod, BuildMethodM buildMethod, ValidatorM validator) throws IOException {
        StringBuilder arguments;
        ArgumentListM constructorArguments;
        properties = new PropertyListM(properties);
        String pojoTypeDeclaration = this.writer.compressType(pojoType.getGenericTypeDeclaration());
        String pojoClassname = this.writer.compressType(pojoType.getName());
        this.writer.emitEmptyLine().emitJavadoc("Creates a new {@link %s} based on this builder's settings.\n\n@return the created %s", pojoClassname, pojoClassname);
        if (buildMethod.isOverrides()) {
            this.writer.emitAnnotation(Override.class);
        }
        this.writer.beginMethod(pojoTypeDeclaration, "build", EnumSet.of(Modifier.PUBLIC), new String[0]).beginControlFlow("try", new Object[0]);
        if (!hasBuilderProperties) {
            String arguments2;
            if (factoryMethod == null) {
                arguments2 = properties.filterOutPropertiesWritableViaConstructorParameter(builderType).toArgumentString();
                this.writer.emitStatement("%s result = new %s(%s)", pojoTypeDeclaration, pojoTypeDeclaration, arguments2);
            } else {
                arguments2 = properties.filterOutPropertiesWritableViaFactoryMethodParameter(builderType).toArgumentString();
                String factoryClass = this.writer.compressType(factoryMethod.getDeclaringClass().getName());
                this.writer.emitStatement("%s result = %s.%s(%s)", pojoTypeDeclaration, factoryClass, factoryMethod.getName(), arguments2);
            }
        } else if (factoryMethod == null) {
            constructorArguments = properties.filterOutPropertiesWritableViaConstructorParameter(builderType);
            arguments = new StringBuilder();
            for (PropertyM prop : constructorArguments.sortByPosition().getPropertyList()) {
                this.writer.emitStatement("%s _%s = !%s && %s!=null?%s.build():%s", this.writer.compressType(prop.getPropertyType().getGenericTypeDeclaration()), prop.getConstructorParameter().getName(), prop.getIsSetFieldName(), prop.getBuilderFieldName(), prop.getBuilderFieldName(), prop.getValueFieldName());
                if (arguments.length() > 0) {
                    arguments.append(", ");
                }
                arguments.append(String.format("_%s", prop.getConstructorParameter().getName()));
            }
            this.writer.emitStatement("%s result = new %s(%s)", pojoTypeDeclaration, pojoTypeDeclaration, arguments.toString());
        } else {
            constructorArguments = properties.filterOutPropertiesWritableViaFactoryMethodParameter(builderType);
            arguments = new StringBuilder();
            for (PropertyM prop : constructorArguments.sortByPosition().getPropertyList()) {
                this.writer.emitStatement("%s _%s = !%s && %s!=null?%s.build():%s", this.writer.compressType(prop.getPropertyType().getGenericType()), prop.getFactoryMethodParameter().getName(), prop.getIsSetFieldName(), prop.getBuilderFieldName(), prop.getBuilderFieldName(), prop.getValueFieldName());
                if (arguments.length() > 0) {
                    arguments.append(", ");
                }
                arguments.append(String.format("_%s", prop.getFactoryMethodParameter().getName()));
            }
            String factoryClass = this.writer.compressType(factoryMethod.getDeclaringClass().getName());
            this.writer.emitStatement("%s result = %s.%s(%s)", pojoTypeDeclaration, factoryClass, factoryMethod.getName(), arguments.toString());
        }
        PropertyListM setterProperties = properties.filterOutPropertiesWritableBy(WriteAccess.Type.SETTER, builderType);
        for (PropertyM prop : setterProperties) {
            this.writer.beginControlFlow("if (%s)", prop.getIsSetFieldName()).emitStatement("result.%s(%s)", prop.getSetterMethod().getName(), prop.getValueFieldName());
            if (hasBuilderProperties) {
                this.writer.nextControlFlow("else if (%s!=null)", prop.getBuilderFieldName()).emitStatement("result.%s(%s.build())", prop.getSetterMethod().getName(), prop.getBuilderFieldName());
            }
            this.writer.endControlFlow();
        }
        PropertyListM writableProperties = properties.filterOutPropertiesWritableBy(WriteAccess.Type.FIELD, builderType);
        for (PropertyM prop : writableProperties) {
            this.writer.beginControlFlow("if (%s)", prop.getIsSetFieldName()).emitStatement("result.%s = %s", prop.getPropertyName(), prop.getValueFieldName());
            if (hasBuilderProperties) {
                this.writer.nextControlFlow("else if (%s!=null)", prop.getBuilderFieldName()).emitStatement("result.%s = %s.build()", prop.getPropertyName(), prop.getBuilderFieldName());
            }
            this.writer.endControlFlow();
        }
        if (validator != null) {
            this.writer.emitStatement("%s.%s(result)", validator.getFieldName(), validator.getMethodName());
        }
        this.writer.emitStatement("return result", new Object[0]).nextControlFlow("catch (RuntimeException ex)", new Object[0]).emitStatement("throw ex", new Object[0]).nextControlFlow("catch (Exception ex)", new Object[0]).emitStatement("throw new java.lang.reflect.UndeclaredThrowableException(ex)", new Object[0]).endControlFlow().endMethod();
    }

    private void emitWithMethodUsingBuilderInterface(TypeM builderType, TypeM selfType, TypeM interfaceType, TypeM pojoType, PropertyM prop) throws IOException {
        String builderFieldName = prop.getBuilderFieldName();
        String isSetFieldName = prop.getIsSetFieldName();
        String withMethodName = prop.getWithMethodName();
        String pojoTypeStr = this.writer.compressType(pojoType.getName());
        String parameterTypeStr = prop.getParameterizedBuilderInterfaceType(interfaceType).getGenericTypeDeclaration();
        this.writer.emitEmptyLine().emitJavadoc("Sets the default builder for the {@link %s#%s} property.\n\n@param builder the default builder\n@return this builder", pojoTypeStr, prop.getPropertyName()).beginMethod(selfType.getGenericTypeDeclaration(), withMethodName, EnumSet.of(Modifier.PUBLIC), parameterTypeStr, "builder").emitStatement("this.%s = builder", builderFieldName).emitStatement("this.%s = false", isSetFieldName).emitStatement("return self", new Object[0]).endMethod();
    }

    private void emitWithMethod(TypeM builderType, TypeM selfType, TypeM pojoType, PropertyM prop) throws IOException {
        String parameterTypeStr;
        String valueFieldName = prop.getValueFieldName();
        String isSetFieldName = prop.getIsSetFieldName();
        String withMethodName = prop.getWithMethodName();
        String pojoTypeStr = this.writer.compressType(pojoType.getName());
        if (prop.getPropertyType().isArrayType() && prop.getPreferredWriteAccessFor(builderType).isVarArgs()) {
            ArrayTypeM arrayType = (ArrayTypeM)prop.getPropertyType();
            String paramTypeStr = arrayType.getGenericTypeDeclaration();
            parameterTypeStr = this.writer.compressType(paramTypeStr);
            parameterTypeStr = parameterTypeStr.substring(0, parameterTypeStr.length() - 2).concat("...");
        } else {
            parameterTypeStr = prop.getPropertyType().getGenericTypeDeclaration();
        }
        this.writer.emitEmptyLine().emitJavadoc("Sets the default value for the {@link %s#%s} property.\n\n@param value the default value\n@return this builder", pojoTypeStr, prop.getPropertyName()).beginMethod(selfType.getGenericTypeDeclaration(), withMethodName, EnumSet.of(Modifier.PUBLIC), parameterTypeStr, "value").emitStatement("this.%s = value", valueFieldName).emitStatement("this.%s = true", isSetFieldName).emitStatement("return self", new Object[0]).endMethod();
    }

    private void emitWithOptionalMethod(TypeM builderType, TypeM selfType, TypeM pojoType, PropertyM prop, TypeM optionalType) throws IOException {
        TypeM optionalParameterType = prop.getOptionalPropertyType(optionalType);
        if (optionalParameterType == null) {
            return;
        }
        String withMethodName = prop.getWithMethodName();
        String pojoTypeStr = this.writer.compressType(pojoType.getName());
        String optionalParameterTypeStr = optionalParameterType.getGenericTypeDeclaration();
        optionalParameterTypeStr = this.writer.compressType(optionalParameterTypeStr);
        this.writer.emitEmptyLine().emitJavadoc("Optionally sets the default value for the {@link %s#%s} property.\n\n@param value the default value\n@return this builder", pojoTypeStr, prop.getPropertyName()).beginMethod(selfType.getGenericTypeDeclaration(), withMethodName, EnumSet.of(Modifier.PUBLIC), optionalParameterTypeStr, "optionalValue").emitStatement("return optionalValue.isPresent()?%s(optionalValue.get()):self", withMethodName).endMethod();
    }

    private void emitConstructor(TypeM builderType, TypeM selfType) throws IOException {
        String selfTypeStr = this.writer.compressType(selfType.getGenericTypeDeclaration());
        String builderTypeName = this.writer.compressType(builderType.getName());
        this.writer.emitEmptyLine().emitJavadoc("Creates a new {@link %s}.", builderTypeName).beginConstructor(EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("self = (%s)this", selfTypeStr).endConstructor();
    }

    private void emitPropertyFields(PropertyM prop, TypeM interfaceType, boolean hasBuilderProperties) throws IOException {
        String valueFieldName = prop.getValueFieldName();
        String isSetFieldName = prop.getIsSetFieldName();
        this.writer.emitField(prop.getPropertyType().getGenericTypeDeclaration(), valueFieldName, EnumSet.of(Modifier.PROTECTED));
        this.writer.emitField("boolean", isSetFieldName, EnumSet.of(Modifier.PROTECTED));
        if (interfaceType != null && hasBuilderProperties) {
            this.writer.emitField(prop.getParameterizedBuilderInterfaceType(interfaceType).getGenericTypeDeclaration(), prop.getBuilderFieldName(), EnumSet.of(Modifier.PROTECTED));
        }
    }

    private void emitButMethod(TypeM selfType) throws IOException {
        String builderTypeStr = this.writer.compressType(selfType.getGenericTypeDeclaration());
        this.writer.emitEmptyLine().emitJavadoc("Returns a clone of this builder.\n\n@return the clone", new Object[0]);
        if (selfType.isGeneric()) {
            this.writer.emitAnnotation(SuppressWarnings.class, (Object)JavaWriter.stringLiteral("unchecked"));
        }
        this.writer.beginMethod(builderTypeStr, "but", EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("return (%s)clone()", builderTypeStr).endMethod();
    }

    private void emitCloneMethod(TypeM selfType) throws IOException {
        String builderTypeStr = this.writer.compressType(selfType.getGenericTypeDeclaration());
        this.writer.emitEmptyLine().emitJavadoc("Returns a clone of this builder.\n\n@return the clone", new Object[0]).emitAnnotation(Override.class).beginMethod("Object", "clone", EnumSet.of(Modifier.PUBLIC), new String[0]).beginControlFlow("try", new Object[0]);
        if (selfType.isGeneric()) {
            this.writer.emitAnnotation(SuppressWarnings.class, (Object)JavaWriter.stringLiteral("unchecked"));
        }
        this.writer.emitStatement("%s result = (%s)super.clone()", builderTypeStr, builderTypeStr).emitStatement("result.self = result", new Object[0]).emitStatement("return result", new Object[0]).nextControlFlow("catch (CloneNotSupportedException e)", new Object[0]).emitStatement("throw new InternalError(e.getMessage())", new Object[0]).endControlFlow().endMethod();
    }
}

